<?php

namespace Tests\Unit;

use Tests\TestCase;
use Illuminate\Support\Facades\Session;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Foundation\Testing\DatabaseTransactions;

class UserVisitorMessageTest extends TestCase
{
    use WithFaker;

    use DatabaseTransactions;

    protected function setUp(): void
    {
        parent::setUp();
        // to see description
        $this->withoutExceptionHandling();

        // Start session to enables csrf_token()
        Session::start();
    }
    /**
     * A basic unit test example.
     *
     * @return void
     */
    public function testUserCanCreateVisitorMessage()
    {

        $dataToSave = [
            'name' => $this->faker->name,
            'email' => $this->faker->email,
            'subject' => $this->faker->sentence,
            'message' => $this->faker->paragraph,
        ];
        $response= $this->post(route('userVisitorMessages.store'),
            array_merge($dataToSave, ['_token'=> csrf_token()] ) );

        $response->assertStatus(200);
        $response->assertSee(true);

    }
}
