<!-- Start footer -->
<footer class="footer section pb-0 ">
    <div class="container">
        <div class="row justify-content-between ">
            <div class="col-lg-3">
                <div class="content">
                    <img src="<?php echo e(asset($logo ?? 'assets/web/images/logo.svg')); ?>" alt="" class="logo"/>
                    <p class="p"><?php echo e(stripText(pages(7)->description)); ?></p>
                </div>
            </div>
            <div class="col-lg-2">
                <div class="content">
                    <h5 class="title color-primary mb-4"><?php echo e(__('main.important_links')); ?></h5>
                    <div class="links">
                        <a href="<?php echo e(LaravelLocalization::getLocalizedURL($lang, route('aboutUs'), [], true)); ?>"><?php echo e(__('main.about_center')); ?></a>
                        <a href="<?php echo e(LaravelLocalization::getLocalizedURL($lang, route('gallery.index'), [], true)); ?>"><?php echo e(__('galleries.photos_videos_galleries')); ?></a>
                        <a href="<?php echo e(LaravelLocalization::getLocalizedURL($lang, route('branch.index'), [], true)); ?>"><?php echo e(__('branches.head')); ?></a>
                        <a href="<?php echo e(LaravelLocalization::getLocalizedURL($lang, route('contact.index'), [], true)); ?>"><?php echo e(__('main.contact_us')); ?></a>
                        <a href="<?php echo e(LaravelLocalization::getLocalizedURL($lang, route('pages', 'terms-condition'), [], true)); ?>"><?php echo e(pages([5])->title); ?> </a>
                        <a href="<?php echo e(LaravelLocalization::getLocalizedURL($lang, route('pages', 'evacuation-responsibilaty'), [], true)); ?>"><?php echo e(pages([6])->title); ?></a>
                    </div>
                </div>
            </div>
            <div class="col-lg-3">
                <div class="content">
                    <h5 class="title color-primary mb-4"><?php echo e(__('main.center_services')); ?></h5>
                    <div class="links">
                        <?php if(count(services())): ?>
                            <?php $__currentLoopData = services(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a href="<?php echo e(LaravelLocalization::getLocalizedURL($lang, route('service.show', $service->id), [], true)); ?>"><?php echo e($service->name); ?></a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="col-lg-3">
                <div class="content">
                    <h5 class="title color-primary mb-4"><?php echo e(__('main.newsletter_subscription')); ?></h5>
                    <p class="p"><?php echo e(__('main.newsletter_subscription_hint')); ?></p>
                    <form method="post" action="<?php echo e(route('newsletter')); ?>" class="newsletter_form">
                        <div class="form-group">
                            <input type="text" name="email" class="form-control newsletter_email" placeholder="<?php echo e(__('newsletters.email')); ?>">
                            <button class="butn primary_butn newsletter_button"><?php echo e(__('main.subscribe')); ?></button>
                        </div>
                    </form>
                    <div class="down_links d-flex mt-4">
                        <a target="_blank" href="<?php echo e($settings['apple_store_link']); ?>">
                            <img src="<?php echo e(asset('assets/web/images/icons/apple_store.svg')); ?>" alt="" class="down_img"/>
                        </a>
                        <a target="_blank" href="<?php echo e($settings['google_play_link']); ?>">
                            <img src="<?php echo e(asset('assets/web/images/icons/play_store.svg')); ?>" alt="" class="down_img"/>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="foot py-3 mt-4">
        <div class="container">
            <p class="copyright_p text-white text-center mb-0  ">

                <?php echo __('main.copy_right'); ?>

            </p>
        </div>
    </div>
</footer>
<!--Scroll to top button-->
<div class="progress-wrap ">
    <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102"><path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" style="transition: stroke-dashoffset 10ms linear 0s; stroke-dasharray: 307.919, 307.919; stroke-dashoffset: 220.587;"></path></svg>
</div>
<?php /**PATH C:\wamp64\www\foot\resources\views/web/layouts/footer.blade.php ENDPATH**/ ?>