<?php $__env->startSection('content'); ?>
    <section class="contact-pg bg-light section ">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <h1 class="sec_title mb-5">  <?php echo e(__('visitorMessages.send_message')); ?> </h1>
                    <div class="form_box">
                        <form method="post" action="<?php echo e(route('contact.store')); ?>" class="contact_us_form">
                            <div class="form-group mb-4">
                                <label class="label mb-2"><?php echo e(__('visitorMessages.name')); ?> <span class="text-danger">*</span></label>
                                <input type="text" name="name" class="form-control" placeholder="<?php echo e(__('visitorMessages.type_here')); ?>">
                            </div>
                            <div class="form-group mb-4">
                                <label class="label mb-2"><?php echo e(__('visitorMessages.email')); ?><span class="text-danger">*</span></label>
                                <input style="direction: rtl" type="email" name="email" class="form-control" placeholder="<?php echo e(__('visitorMessages.type_here')); ?>">
                            </div>
                            <div class="form-group mb-4">
                                <label class="label mb-2"><?php echo e(__('visitorMessages.phone')); ?><span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text" id="basic-addon1">+966</span>
                                    <input style="direction: rtl" type="tel" name="phone" class="form-control" placeholder="XXXXXXXXXXXX">
                                </div>
                            </div>




                            <div class="form-group mb-4">
                                <label class="label mb-2"><?php echo e(__('visitorMessages.message')); ?>  <span class="text-danger">*</span></label>
                                <textarea name="message" class="form-control" placeholder="<?php echo e(__('visitorMessages.type_here')); ?>" rows="5"></textarea>
                            </div>
                            <button class="butn secondary_butn w-100 py-3 fs-6 contact_us_button"><?php echo e(__('visitorMessages.send')); ?> </button>
                        </form>
                    </div>
                </div>
                <div class="col-lg-6">
                    <h1 class="sec_title mb-5"><?php echo e(__('workHours.head')); ?></h1>
                    <div class="hours_box">
                        <?php if(count($workHours)): ?>
                            <?php $__currentLoopData = $workHours; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day => $workHour): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="item">
                                    <div class="row">
                                        <div class="col-4">
                                            <span class="day"><?php echo e(__('workHours.'.$day)); ?></span>
                                        </div>
                                        <div class="col-8">
                                            <span class="hours color-secondary"><?php echo e($workHour); ?></span>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-lg-12 mt-5">
                    <h1 class="sec_title mb-5"><?php echo e(__('settings.site_map')); ?></h1>
                    <div class="map_box map_container"><?php echo $settings['site_map']; ?></div>
                </div>
                <div class="col-lg-12 mt-5">
                    <h1 class="sec_title mb-5"><?php echo e(__('visitorMessages.management_info')); ?></h1>
                    <div class="about_cards contact_cards mt-0">
                        <div class="swiper-container contactCards_swiper zi-5">
                            <div class="swiper-wrapper pb-5">
                                <?php if($settings['site_email'] ?? null): ?>
                                    <div class="swiper-slide">
                                        <div class="about_card">
                                            <img src="<?php echo e(asset('assets/web/images/icons/contact_cards_1.svg')); ?>" alt="" class="icon"/>
                                            <h5 class="title fw-bold"><?php echo e(__('settings.site_email')); ?></h5>
                                            <p class="p"><?php echo e($settings['site_email']); ?></p>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <?php if($settings['site_phone'] ?? null): ?>
                                    <div class="swiper-slide">
                                        <div class="about_card">
                                            <img src="<?php echo e(asset('assets/web/images/icons/contact_cards_2.svg')); ?>" alt="" class="icon"/>
                                            <h5 class="title fw-bold"><?php echo e(__('settings.site_phone')); ?></h5>
                                            <p class="p"><?php echo e($settings['site_phone']); ?></p>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <?php if($settings['site_address_'.$lang] ?? null): ?>
                                    <div class="swiper-slide">
                                        <div class="about_card">
                                            <img src="<?php echo e(asset('assets/web/images/icons/contact_cards_3.svg')); ?>" alt="" class="icon"/>
                                            <h5 class="title fw-bold"><?php echo e(__('settings.site_address')); ?></h5>
                                            <p class="p"><?php echo e($settings['site_address_'.$lang]); ?></p>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="social_links d-flex justify-content-center">
                            <?php if($settings['instagram'] ?? null): ?>
                                <a target="_blank" href="<?php echo e($settings['instagram']); ?>">
                                    <img src="<?php echo e(asset('assets/web/images/icons/instagram.svg')); ?>" alt="" class="icon"/>
                                </a>
                            <?php endif; ?>
                            <?php if($settings['twitter'] ?? null): ?>
                                <a target="_blank" href="<?php echo e($settings['twitter']); ?>">
                                    <img src="<?php echo e(asset('assets/web/images/icons/twitter.svg')); ?>" alt="" class="icon"/>
                                </a>
                            <?php endif; ?>
                            <?php if($settings['facebook'] ?? null): ?>
                                <a target="_blank" href="<?php echo e($settings['facebook']); ?>">
                                    <img src="<?php echo e(asset('assets/web/images/icons/fb.svg')); ?>" alt="" class="icon"/>
                                </a>
                            <?php endif; ?>
                        </div>

                        <img src="<?php echo e(asset('assets/web/images/vector-2.svg')); ?>" alt="" class="vector_bl"/>
                        <img src="<?php echo e(asset('assets/web/images/vector-1.svg')); ?>" alt="" class="vector_tr"/>

                    </div>

                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('inner_js'); ?>

    <script>

        $('.contact_us_button').click(async function (e) {
            e.preventDefault();

            $(this).prop('disabled', true);

            let form = $('.contact_us_form'),
                data = new FormData(form[0]),
                url = form.attr('action'),
                method = form.attr('method');

            const response=await ajax({
                url,
                data,
                dataType: 'json',
                method
            });

            if (response.errors){
                $(this).prop('disabled', false);
                toasterError(response.errors);
            }

            if (response.message){
                toasterSuccess(response.message);
                $('input, textarea').val('');
            }

        });

        $(document).ready(function () {
            $('.map_container iframe').attr('width', '100%').attr('height', '400')
        })
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('web.layouts.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\foot\resources\views/web/contacts/index.blade.php ENDPATH**/ ?>