<?php $__env->startSection('content'); ?>
    <section class="booking-det section bg-light">
        <div class="container">
            <div class="text_box text-center">
                <h1 class="title color-primary mb-3 fw-bold"><?php echo e(__('reservations.reservation_added_successfully')); ?></h1>
                <p class="p">
                    <?php echo e(__('reservations.reservation_details_hint')); ?>

                </p>
            </div>
            <div class="booking-pg mt-5">
                <div class="inner">
                    <h1 class="sec_title m-auto mb-5">  <?php echo e($reservation['service_name']); ?>  </h1>
                    <div class="session_time d-flex justify-content-center align-items-center">
                        <img src="<?php echo e(asset('assets/web/images/icons/clock.svg')); ?>" alt="" class="icon"/>
                        <div class="txt">
                            <h5 class="title fw-bold"><?php echo e(__('reservations.session_duration')); ?></h5>
                            <p class="p fs-6 mb-0"><?php echo e($reservation['service_duration'] . ' ' . __('reservations.minutes')); ?></p>
                        </div>
                    </div>
                    <div class="box">
                        <div class="row mt-5">
                            <div class="col-lg-6">
                                <div class="sm_box py-5 px-4 mb-0 h-100 ">
                                    <h5 class="sec_title mb-5"><?php echo e(__('reservations.reservation_date')); ?></h5>
                                    <div class="booking_det d-flex align-items-center">
                                        <img src="<?php echo e(asset('assets/web/images/icons/booking-1.svg')); ?>" alt="" class="icon"/>
                                        <div class="txt">
                                            <p class="p mb-1"><?php echo e($reservation['appointment_date']); ?></p>
                                            <h5 class="name mb-0"><?php echo e($reservation['doctor_name']); ?></h5>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="branch_card my-0">
                                    <h5 class="title fw-bold d-flex align-items-center mb-4">
                                        <span class="icon"><i class="fa-solid fa-location-dot"></i></span>
                                        <?php echo e($reservation['branch_name']); ?>

                                    </h5>
                                    <p class="p mb-4">
                                        <img src="<?php echo e(asset('assets/web/images/icons/contact_cards_3.svg')); ?>" alt="" class="sm_icon"/>
                                        <?php echo e($reservation['branch_address']); ?>

                                    </p>
                                    <p class="p mb-4">
                                        <img src="<?php echo e(asset('assets/web/images/icons/contact_cards_2.svg')); ?>" alt="" class="sm_icon"/>
                                        <?php echo e($reservation['branch_phone']); ?>

                                    </p>
                                    <a href="#" class="butn gray_butn color-primary fw-bold w-100" data-bs-toggle="modal" data-bs-target="#showMapModal">
                                        <?php echo e(__('branches.show_branch_on_map')); ?>

                                    </a>
                                </div>
                            </div>
                        </div>
                        <a href="<?php echo e(url(getCurrentLocale().'/booking/calendar/'.$reservation['id'])); ?>" class="butn primary_butn m-auto mt-5"><?php echo e(__('reservations.add_appointment_to_calender')); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <div class="modal fade" id="showMapModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg  modal-dialog-centered">
            <div class="modal-content">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                <div class="modal-body">
                    <div class="map_box map_container"><?php echo $reservation['branch_map']; ?></div>
                </div>
            </div>
        </div>
    </div>

    <!-- Success Modal -->
    <?php if(session('process_done')): ?>
    <div class="modal stateModal fade successModal" id="confirmModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <button type="button" class="butn_close" data-bs-dismiss="modal" aria-label="Close">
                    <i class="fa-solid fa-xmark"></i>
                </button>
                <div class="modal-body">
                    <img src="<?php echo e(asset('assets/web/images/modals/confirm.png')); ?>" alt="" class="img"/>
                    <h3 class="title color-primary  text-center"><b><?php echo e(__('reservations.success_message')); ?></b></h3>

                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('inner_js'); ?>
    <script>

        $(document).ready(function () {
            let processDone = "<?php echo e(session('process_done')); ?>";
            if(processDone){
              $('.successModal').modal('show');
            }
        });

        $('.map_link').click(function () {
            $('.map_modal .modal-body .map_container iframe').attr('width', '100%').attr('height', '300');
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('web.layouts.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\foot\resources\views/web/bookings/reservation_details.blade.php ENDPATH**/ ?>