<?php $__env->startSection('content'); ?>
<div class="side-title">
    <h3><?php echo e($head ?? ''); ?></h3>
</div>

<div class="border-item">
    <form class="form-row add_doctor_form" method="post" action="<?php echo e($action); ?>" enctype="multipart/form-data">
        <?php if($doctor ?? ''  && $doctor->id): ?>
            <?php echo method_field('PUT'); ?>
        <?php endif; ?>
        <?php echo csrf_field(); ?>







            <?php $__currentLoopData = languages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="form-group col-lg-6">
                    <label><?php echo e(meta('name', $language->local) ?? __('doctors.name')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                    <input type="text" class="form-control <?php echo e($errors->has('name_'.$language->local) ? 'is-invalid' : ''); ?>" name="name_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('name', $language->local) ?? __('doctors.name')); ?>" value='<?php echo e(old("name_{$language->local}", $doctor[$language->local]->name ?? "")); ?>'/>
                </div>
                <div class="form-group col-lg-6">
                    <label><?php echo e(meta('specialist', $language->local) ?? __('doctors.specialist')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                    <input type="text" class="form-control <?php echo e($errors->has('specialist_'.$language->local) ? 'is-invalid' : ''); ?>" name="specialist_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('specialist', $language->local) ?? __('doctors.specialist')); ?>" value='<?php echo e(old("specialist_{$language->local}", $doctor[$language->local]->specialist ?? "")); ?>'/>
                </div>
























            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <div class="card">
                <div class="card-header">
                    <h6 class="card-title"><?php echo e(meta('service_ids', $lang) ??  __('doctors.service_ids')); ?> </h6>
                </div>
                <div class="card-body">
                    <?php if( count($services)): ?>
                        <div class="form-group col-lg-12">
                            <div class="row">
                                <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-sm-4">
                                        <div class="custom-control custom-checkbox">
                                            <input type="checkbox" <?php echo e(in_array($service->id, $serviceIds) ? 'checked' : ''); ?> value="<?php echo e($service->id); ?>" class="custom-control-input" id="doctor_<?php echo e($loop->iteration); ?>" name="service_ids[]">
                                            <label class="custom-control-label" for="doctor_<?php echo e($loop->iteration); ?>"> <?php echo e($service->name); ?> </label>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            
            <div class="form-group col-lg-12 image_container">
                <label><?php echo e(meta('image', $lang) ?? __('doctors.image')); ?> </label>
                <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="<?php echo e(old("image", $doctor->image ?? "")); ?>"/>

                <div class="photos main_photo <?php echo e(old('image', $doctor->image ?? '') ? ' wow fadeInUp' : 'hide'); ?>">
                    <div class="col-md-4">
                        <div class="items">
                            <div class="img">
                                <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                    <img src="<?php echo e(asset(old('image', $doctor->image ?? ''))); ?> "  id="image_holder" class="image_holder"/>
                                </a>
                            </div>
                            <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                        </div>
                    </div>
                </div>

                <div class="clearfix"></div>
                <span class="input-group-btn pick_button <?php echo e(old('image', $doctor->image ?? '') ? 'hide' : ''); ?> ">
                <a id="lfm"  data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> <?php echo e(__('dashboard.choose')); ?>

                </a>
             </span>
            </div>
            


        <div class="text-center mt-5 col-12">
            <button class="butn add_doctor_button"><span><?php echo e(__('dashboard.save')); ?></span></button>
        </div>
    </form>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('inner_js'); ?>

    <!-- Editor JS files -->
    <script src="<?php echo e(asset('/assets/admin/js/lib/tinymce.min.js')); ?>"></script>
    
    <script>
        let route_prefix = "<?php echo e(url(config('lfm.prefix'))); ?>",
            url = "<?php echo e(url('/')); ?>/",
            currentLanguage = "<?php echo e($lang); ?>",
            imagePath = "<?php echo e(asset('')); ?>",
            inputName = null;
    </script>

    <script src="<?php echo e(asset('assets/admin/js/editor.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/lfm.js')); ?>"></script>

    <script>
        sendAjax('.add_doctor_button', '.add_doctor_form')
    </script>

<?php $__env->stopSection(); ?>




<?php echo $__env->make('admin.layouts.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\foot\resources\views/admin/doctors/form.blade.php ENDPATH**/ ?>