<?php $__env->startSection('content'); ?>
<div class="side-title">
    <h3><?php echo e($head ?? ''); ?></h3>
</div>

<div class="border-item">
    <form class="form-row add_form" method="post" action="<?php echo e($action); ?>" enctype="multipart/form-data">
        <?php if($service ?? ''  && $service->id): ?>
            <?php echo method_field('PUT'); ?>
        <?php endif; ?>
        <?php echo csrf_field(); ?>

            <div class="form-group col-lg-12">
                <label><?php echo e(meta('durations', $lang) ?? __('services.durations')); ?> </label>
                <input type="number" min="1" class="form-control <?php echo e($errors->has('durations') ? 'is-invalid' : ''); ?>" name="durations" placeholder="<?php echo e(meta('durations', $lang) ?? __('siteSliders.durations')); ?>" value='<?php echo e(old("durations", $service->durations ?? null)); ?>'/>
            </div>

            <?php $__currentLoopData = languages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="form-group col-lg-12">
                    <label><?php echo e(meta('name', $language->local) ?? __('services.name')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                    <input type="text" class="form-control <?php echo e($errors->has('name_'.$language->local) ? 'is-invalid' : ''); ?>" name="name_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('name', $language->local) ?? __('services.name')); ?>" value='<?php echo e(old("name_{$language->local}", $service[$language->local]->name ?? "")); ?>'/>
                </div>

                <div class="form-group col-lg-12">
                    <label><?php echo e(meta('main_section_name', $language->local) ?? __('services.main_section_name')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                    <input type="text" class="form-control <?php echo e($errors->has('main_section_name_'.$language->local) ? 'is-invalid' : ''); ?>" name="main_section_name_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('main_section_name', $language->local) ?? __('services.main_section_name')); ?>" value='<?php echo e(old("main_section_name_{$language->local}", $mainSection['title_'.$language->local] ?? "")); ?>'/>
                </div>
                <div class="form-group col-lg-12">
                    <label><?php echo e(meta('main_section_desc', $language->local) ?? __('services.main_section_desc')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                    <textarea rows="5" name="main_section_desc_<?php echo e($language->local); ?>" class="form-control <?php echo e($errors->has('main_section_desc_'.$language->local) ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(meta('main_section_desc', $language->local) ?? __('services.main_section_desc')); ?>"><?php echo e(old("main_section_desc_{$language->local}", $mainSection['desc_'.$language->local] ?? "")); ?></textarea>
                </div>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            
            <div class="sliders_container col-md-12">
                
                <?php if(count($mainSection['sliders'] ?? [])): ?>
                    <?php $__currentLoopData = $mainSection['sliders']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mainSectionSlider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="form-group col-lg-12 card deleted_slider slider_card">
                            <div class="row">
                                <div class="form-group col-md-12 d-flex justify-content-end">
                                    <a href="#" class="delete_slider mt-3"><i class="fa fa-trash-alt text-danger fa-2x"></i></a>
                                </div>
                                <div class="form-group col-md-12">
                                    <input type="text" name="main_section_video_url[]"  placeholder="<?php echo e(__('services.main_section_video_url')); ?>" class="form-control" value="<?php echo e($mainSectionSlider['url'] ?? null); ?>"/>
                                </div>

                                <div class="form-group col-lg-12">
                                    <label><?php echo e(__('services.main_section_image')); ?></label>
                                    <input id="image_thumbnail_<?php echo e($loop->iteration); ?>" class="image_thumbnail_<?php echo e($loop->iteration); ?>" type="hidden" name="main_section_image[]" value="<?php echo e($mainSectionSlider['image'] ?? null); ?>"/>

                                    <div class="photos main_photo_<?php echo e($loop->iteration); ?> wow fadeInUp">
                                        <div class="col-lg-4">
                                            <div class="items">
                                                <div class="img">
                                                    <a href="#" id="lfm" data-input=".image_thumbnail_<?php echo e($loop->iteration); ?>" data-preview=".image_holder_<?php echo e($loop->iteration); ?>" class="lfm" data-hide=".pick_button_<?php echo e($loop->iteration); ?>">
                                                        <img src="<?php echo e(asset($mainSectionSlider['image'] ?? null)); ?> " id="image_holder_<?php echo e($loop->iteration); ?>" class="image_holder_<?php echo e($loop->iteration); ?>"/>
                                                    </a>
                                                </div>
                                                <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail_<?php echo e($loop->iteration); ?>" data-hide=".main_photo_<?php echo e($loop->iteration); ?>" data-show=".pick_button_<?php echo e($loop->iteration); ?>"><i class="fas fa-times"></i></a>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="clearfix"></div>
                                    <span class="input-group-btn pick_button_<?php echo e($loop->iteration); ?> <?php echo e(($mainSectionSlider['image'] ?? '') ? 'hide' : ''); ?>">
                                        <a id="lfm" data-input=".image_thumbnail_<?php echo e($loop->iteration); ?>" data-preview=".image_holder_<?php echo e($loop->iteration); ?>" data-show=".main_photo_<?php echo e($loop->iteration); ?>" data-hide=".pick_button_<?php echo e($loop->iteration); ?>" class="lfm btn btn-primary text-light">
                                            <i class="fas fa-camera-retro"></i> <?php echo e(__('dashboard.choose')); ?>

                                        </a>
                                    </span>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>

            </div>
            <div class="form-group col-lg-12 mt-3 mb-5">
                <a href="#" class="btn btn-primary btn-block add_slide"><i class="fa fa-plus"></i> <?php echo e(__('services.add_slider')); ?></a>
            </div>
            

            
            <div class="sub_sections_container">
                <?php if(count($subSections)): ?>
                <?php $__currentLoopData = $subSections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subSection): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="card mb-3 sub_section_item">
                        <div class="form-group col-md-12 d-flex justify-content-end">
                            <a href="#" class="delete_sub_section_item mt-3"><i class="fa fa-trash-alt text-danger fa-2x"></i></a>
                        </div>
                        <div class="card-body row">
                            <?php $__currentLoopData = languages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="form-group col-lg-12">
                                    <label><?php echo e(meta('sub_section_name', $language->local) ?? __('services.sub_section_name')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                                    <input type="text" class="form-control <?php echo e($errors->has('sub_section_name_'.$language->local) ? 'is-invalid' : ''); ?>" name="sub_section_name_<?php echo e($language->local); ?>[]" placeholder="<?php echo e(meta('sub_section_name', $language->local) ?? __('services.sub_section_name')); ?>" value='<?php echo e(old("sub_section_name_{$language->local}", $subSection['title_'.$language->local] ?? "")); ?>'/>
                                </div>
                                <div class="form-group col-lg-12">
                                    <label><?php echo e(meta('sub_section_desc', $language->local) ?? __('services.sub_section_desc')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                                    <textarea rows="5" name="sub_section_desc_<?php echo e($language->local); ?>[]" class="form-control <?php echo e($errors->has('sub_section_desc_'.$language->local) ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(meta('sub_section_desc', $language->local) ?? __('services.sub_section_desc')); ?>"><?php echo e(old("sub_section_desc_{$language->local}", $subSection['desc_'.$language->local] ?? "")); ?></textarea>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <div class="form-group col-lg-12">
                                <label><?php echo e(__('services.sub_section_image')); ?></label>
                                <input id="sub_image_thumbnail_<?php echo e($loop->iteration); ?>" class="sub_image_thumbnail_<?php echo e($loop->iteration); ?>" type="hidden" name="sub_section_image[]" value="<?php echo e($subSection['image'] ?? null); ?>"/>

                                <div class="photos sub_main_photo_<?php echo e($loop->iteration); ?> wow fadeInUp">
                                    <div class="col-lg-4">
                                        <div class="items">
                                            <div class="img">
                                                <a href="#" id="lfm" data-input=".sub_image_thumbnail_<?php echo e($loop->iteration); ?>" data-preview=".sub_image_holder_<?php echo e($loop->iteration); ?>" class="lfm" data-hide=".sub_pick_button_<?php echo e($loop->iteration); ?>">
                                                    <img src="<?php echo e(asset($subSection['image'] ?? null)); ?> " id="sub_image_holder_<?php echo e($loop->iteration); ?>" class="image_holder_<?php echo e($loop->iteration); ?>"/>
                                                </a>
                                            </div>
                                            <a href="#" class="showHide resetImage close" data-empty=".sub_image_thumbnail_<?php echo e($loop->iteration); ?>" data-hide=".sub_main_photo_<?php echo e($loop->iteration); ?>" data-show=".sub_pick_button_<?php echo e($loop->iteration); ?>"><i class="fas fa-times"></i></a>
                                        </div>
                                    </div>
                                </div>

                                <div class="clearfix"></div>
                                <span class="input-group-btn sub_pick_button_<?php echo e($loop->iteration); ?> <?php echo e(($subSection['image'] ?? '') ? 'hide' : ''); ?>">
                        <a id="lfm" data-input=".sub_image_thumbnail_<?php echo e($loop->iteration); ?>" data-preview=".sub_image_holder_<?php echo e($loop->iteration); ?>" data-show=".sub_main_photo_<?php echo e($loop->iteration); ?>" data-hide=".sub_pick_button_<?php echo e($loop->iteration); ?>" class="lfm btn btn-primary text-light">
                            <i class="fas fa-camera-retro"></i> <?php echo e(__('dashboard.choose')); ?>

                        </a>
                    </span>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>

            <div class="form-group col-lg-12 mt-3 mb-5">
                <a href="#" class="btn btn-primary btn-block add_sub_section"><i class="fa fa-plus"></i> <?php echo e(__('services.add_sub_section')); ?></a>
            </div>

            

            
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title"><?php echo e(meta('branch_ids', $lang) ??  __('services.branch_ids')); ?> </h6>
                </div>
                <div class="card-body">
                    <?php if( count($branches)): ?>
                        <div class="form-group col-lg-12">
                            <div class="row">
                                <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-sm-4">
                                        <div class="custom-control custom-checkbox">
                                            <input type="checkbox" <?php echo e(in_array($branch->id, $branchIds) ? 'checked' : ''); ?> value="<?php echo e($branch->id); ?>" class="custom-control-input" id="branch_<?php echo e($loop->iteration); ?>" name="branch_ids[]">
                                            <label class="custom-control-label" for="branch_<?php echo e($loop->iteration); ?>"> <?php echo e($branch->name); ?> </label>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            


            
            <div class="form-group col-lg-12 image_container">
                <label><?php echo e(meta('image', $lang) ?? __('services.image')); ?> </label>
                <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="<?php echo e(old("image", $service->image ?? "")); ?>"/>

                <div class="photos main_photo <?php echo e(old('image', $service->image ?? '') ? ' wow fadeInUp' : 'hide'); ?>">
                    <div class="col-md-4">
                        <div class="items">
                            <div class="img">
                                <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                    <img src="<?php echo e(asset(old('image', $service->image ?? ''))); ?> "  id="image_holder" class="image_holder"/>
                                </a>
                            </div>
                            <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                        </div>
                    </div>
                </div>

                <div class="clearfix"></div>
                <span class="input-group-btn pick_button <?php echo e(old('image', $service->image ?? '') ? 'hide' : ''); ?> ">
                <a id="lfm"  data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> <?php echo e(__('dashboard.choose')); ?>

                </a>
             </span>
            </div>
            


        <div class="text-center mt-5 col-12">
            <button class="butn add_button"><span><?php echo e(__('dashboard.save')); ?></span></button>
        </div>
    </form>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('inner_js'); ?>

    <!-- Editor JS files -->
    <script src="<?php echo e(asset('/assets/admin/js/lib/tinymce.min.js')); ?>"></script>
    
    <script>
        let route_prefix = "<?php echo e(url(config('lfm.prefix'))); ?>",
            url = "<?php echo e(url('/')); ?>/",
            currentLanguage = "<?php echo e($lang); ?>",
            imagePath = "<?php echo e(asset('')); ?>",
            inputName = null;
    </script>

    <script src="<?php echo e(asset('assets/admin/js/editor.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/lfm.js')); ?>"></script>

    <script>

        let choose = "<?php echo e(__('dashboard.choose')); ?>",
            addSliderTitle = "<?php echo e(__('services.add_slider')); ?>",
            sliderImage = "<?php echo e(__('services.main_section_image')); ?>",
            videoUrl = "<?php echo e(__('services.main_section_video_url')); ?>",
            subSectionName = "<?php echo e(__('services.sub_section_name')); ?>",
            subSectionDesc = "<?php echo e(__('services.sub_section_desc')); ?>",
            subSectionImage = "<?php echo e(__('services.sub_section_image')); ?>";

        sendAjax('.add_button', '.add_form');

        $('.add_slide').click(function (e) {
            e.preventDefault();
            let counter = (Math.random()*100000).toString(20).replace('.', '_');
            let htmlContent = `
                <div class="form-group col-lg-12 card deleted_slider slider_card">
                       <div class="row">
                       <div class="form-group col-md-12 d-flex justify-content-end">
                       <a href="#" class="delete_slider mt-3"><i class="fa fa-trash-alt text-danger fa-2x"></i></a>
                       </div>
                        <div class="form-group col-md-12">
                            <input type="text" name="main_section_video_url[]"  placeholder="${videoUrl}" class="form-control" value=""/>
                        </div>

                         <div class="form-group col-lg-12">
                                <label>${sliderImage}</label>
                                <input id="image_thumbnail_${counter}" class="image_thumbnail_${counter}" type="hidden" name="main_section_image[]" value=""/>

                                <div class="photos main_photo_${counter} hide">
                                    <div class="col-lg-4">
                                        <div class="items">
                                            <div class="img">
                                                <a href="#" id="lfm" data-input=".image_thumbnail_${counter}" data-preview=".image_holder_${counter}" class="lfm" data-hide=".pick_button_${counter}">
                                                    <img src="" id="image_holder_${counter}" class="image_holder_${counter}"/>
                                                </a>
                                            </div>
                                            <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail_${counter}" data-hide=".main_photo_${counter}" data-show=".pick_button_${counter}"><i class="fas fa-times"></i></a>
                                        </div>
                                    </div>
                                </div>

                                <div class="clearfix"></div>
                                <span class="input-group-btn pick_button_${counter}">
                                <a id="lfm" data-input=".image_thumbnail_${counter}" data-preview=".image_holder_${counter}" data-show=".main_photo_${counter}" data-hide=".pick_button_${counter}" class="lfm btn btn-primary text-light">
                                    <i class="fas fa-camera-retro"></i> ${choose}
                                </a>
                             </span>
                            </div>
                       </div>
                    </div>`;

            $('.sliders_container').append(htmlContent);

        });

        $(document).on('click', '.delete_slider', function (e) {
            e.preventDefault();
            $(this).parents('.deleted_slider').remove();
        });

        /**
         * Add sub section block
         */

        $('.add_sub_section').click(function (e) {
            e.preventDefault();
            let counter = (Math.random()*100000).toString(20).replace('.', '_');
            console.log(counter)
            let htmlContent = `
                <div class="card mb-3 sub_section_item">
                    <div class="form-group col-md-12 d-flex justify-content-end">
                        <a href="#" class="delete_sub_section_item mt-3"><i class="fa fa-trash-alt text-danger fa-2x"></i></a>
                    </div>
                    <div class="card-body row">
                        <div class="form-group col-lg-12">
                            <label>${subSectionName} (Arabic) </label>
                            <input type="text" class="form-control" name="sub_section_name_ar[]" placeholder="${subSectionName}" value=''/>
                        </div>
                        <div class="form-group col-lg-12">
                            <label>${subSectionDesc} (Arabic) </label>
                            <textarea rows="5" class="form-control" name="sub_section_desc_ar[]" placeholder="${subSectionDesc}"></textarea>
                        </div>
                        <div class="form-group col-lg-12">
                            <label>${subSectionName} (English) </label>
                            <input type="text" class="form-control" name="sub_section_name_en[]" placeholder="${subSectionName}" value=''/>
                        </div>
                        <div class="form-group col-lg-12">
                            <label>${subSectionDesc} (English) </label>
                            <textarea rows="5" class="form-control" name="sub_section_desc_en[]" placeholder="${subSectionDesc}"></textarea>
                        </div>
                        <div class="form-group col-lg-12">
                                <label>${subSectionImage}</label>
                                <input id="image_thumbnail_${counter}" class="image_thumbnail_${counter}" type="hidden" name="sub_section_image[]" value=""/>
                                <div class="photos main_photo_${counter} hide">
                                    <div class="col-lg-4">
                                        <div class="items">
                                            <div class="img">
                                                <a href="#" id="lfm" data-input=".image_thumbnail_${counter}" data-preview=".image_holder_${counter}" class="lfm" data-hide=".pick_button_${counter}">
                                                    <img src="" id="image_holder_${counter}" class="image_holder_${counter}"/>
                                                </a>
                                            </div>
                                            <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail_${counter}" data-hide=".main_photo_${counter}" data-show=".pick_button_${counter}"><i class="fas fa-times"></i></a>
                                        </div>
                                    </div>
                                </div>

                                <div class="clearfix"></div>
                                <span class="input-group-btn pick_button_${counter}">
                                <a id="lfm" data-input=".image_thumbnail_${counter}" data-preview=".image_holder_${counter}" data-show=".main_photo_${counter}" data-hide=".pick_button_${counter}" class="lfm btn btn-primary text-light">
                                    <i class="fas fa-camera-retro"></i> ${choose}
                                </a>
                             </span>
                            </div>
                    </div>
                </div>`;
            $('.sub_sections_container').append(htmlContent);

        });

        $(document).on('click', '.delete_sub_section_item', function (e) {
            e.preventDefault();
            $(this).parents('.sub_section_item').remove();
        });

        $('body').on('DOMNodeInserted', '.sliders_container, .sub_sections_container', function(e) {
            if ($(e.target).find('.lfm')) {
                $('.lfm').filemanager('image', {prefix: route_prefix});
            }
        });


    </script>

<?php $__env->stopSection(); ?>




<?php echo $__env->make('admin.layouts.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\foot\resources\views/admin/services/form.blade.php ENDPATH**/ ?>