<div class="navs-container">
    <!--Start main-nav-->
    <nav class="navbar navbar-expand-lg navbar-light">
        <div class="container">
            <a class="navbar-brand" href="<?php echo e(LaravelLocalization::getLocalizedURL($lang, route('home'), [], true)); ?>">
                <img src="<?php echo e(asset('assets/web/images/logo.svg')); ?>" alt="" class="logo"/>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav m-auto mb-2 mb-lg-0">
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(isActive(route('home'))); ?>" aria-current="page" href="<?php echo e(LaravelLocalization::getLocalizedURL($lang, route('home'), [], true)); ?>"><?php echo e(__('main.home')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(isActive(route('aboutUs'))); ?>" href="<?php echo e(LaravelLocalization::getLocalizedURL($lang, route('aboutUs'), [], true)); ?>"><?php echo e(__('main.about_center')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(isActive(route('service.index'))); ?>" href="<?php echo e(LaravelLocalization::getLocalizedURL($lang, route('service.index'), [], true)); ?>"><?php echo e(__('services.our_medical_services')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(isActive(route('gallery.index'))); ?>" aria-current="page" href="<?php echo e(LaravelLocalization::getLocalizedURL($lang, route('gallery.index'), [], true)); ?>"><?php echo e(__('galleries.photos_videos_galleries')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(isActive(route('branch.index'))); ?>" aria-current="page" href="<?php echo e(LaravelLocalization::getLocalizedURL($lang, route('branch.index'), [], true)); ?>"><?php echo e(__('branches.head')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(LaravelLocalization::getLocalizedURL($lang, route('contact.index'), [], true)); ?>"><?php echo e(__('main.contact_us')); ?></a>
                    </li>
                </ul>
                <div class="nav_end d-flex align-items-center">
                    <a href="<?php echo e(LaravelLocalization::getLocalizedURL($lang, route('home').'#services-sec', [], true)); ?>" class="butn primary_border_butn mx-1"><b><?php echo e(__('main.book_now')); ?></b></a>
                    <?php if($lang == 'ar'): ?>
                        <a href="<?php echo e(LaravelLocalization::getLocalizedURL('en', null, [], true)); ?>" class="butn primary_butn mx-1"><b> <?php echo e(__('main.another_lang_abbr')); ?>  </b></a>
                    <?php else: ?>
                        <a href="<?php echo e(LaravelLocalization::getLocalizedURL('ar', null, [], true)); ?>" class="butn primary_butn mx-1"><b> <?php echo e(__('main.another_lang_abbr')); ?>  </b></a>
                    <?php endif; ?>

                    <div id="modeSwitcher" class="mx-1 ">
                        <input type="checkbox" class="checkbox" id="chk" />
                        <label class="label" for="chk">
                            <i class="fas fa-moon"></i>
                            <div class="ball"></div>
                        </label>
                    </div>
                </div>
            </div>
        </div>
    </nav>
</div>
<?php /**PATH C:\wamp64\www\foot\resources\views/web/layouts/nav.blade.php ENDPATH**/ ?>