<?php $__env->startSection('content'); ?>
<div class="side-title">
    <h3><?php echo e($head ?? ''); ?></h3>
</div>

<div class="border-item">
    <form class="form-row add_form" method="post" action="<?php echo e($action); ?>" enctype="multipart/form-data">
        <?php if($appointment ?? ''  && $appointment->id): ?>
            <?php echo method_field('PUT'); ?>
        <?php endif; ?>
        <?php echo csrf_field(); ?>

        <div class="form-group col-lg-6">
            <label><?php echo e(meta('service_id', $lang) ?? __('appointments.service_id')); ?> </label>
            <select name="service_id" class="form-control <?php echo e($errors->has('service_id') ? 'is-invalid' : ''); ?>">
                <?php if(count($services)): ?>
                    <option value=""><?php echo e(meta('service_id', $lang) ?? __('appointments.service_id')); ?></option>
                    <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option <?php echo e(old('service_id', $appointment->service_id ?? null) == $service->id ? 'selected' : ''); ?> value="<?php echo e($service->id); ?>"><?php echo e($service->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </select>
        </div>

        <div class="form-group col-lg-6">
            <label><?php echo e(meta('doctor_id', $lang) ?? __('appointments.doctor_id')); ?> </label>
            <select name="doctor_id" class="form-control <?php echo e($errors->has('doctor_id') ? 'is-invalid' : ''); ?>">
                <option value=""><?php echo e(meta('doctor_id', $lang) ?? __('appointments.doctor_id')); ?></option>
                <?php if(count($doctors)): ?>
                    <?php $__currentLoopData = $doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doctor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option <?php echo e(old('doctor_id', $appointment->doctor_id ?? null) == $doctor->id ? 'selected' : ''); ?> value="<?php echo e($doctor->id); ?>"><?php echo e($doctor->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </select>
        </div>

            <div class="form-group col-lg-4">
                <label><?php echo e(meta('appointment_date', $lang) ?? __('appointments.appointment_date')); ?> </label>
                <input type="date" class="form-control <?php echo e($errors->has('appointment_date') ? 'is-invalid' : ''); ?>" name="appointment_date" placeholder="<?php echo e(meta('appointment_date', $lang) ?? __('appointments.appointment_date')); ?>" value='<?php echo e(old("appointment_date", $appointment->appointment_date ?? null)); ?>'/>
            </div>
            <div class="form-group col-lg-4">
                <label><?php echo e(meta('doctor_start_shift', $lang) ?? __('appointments.doctor_start_shift')); ?> </label>
                <input type="time" class="form-control <?php echo e($errors->has('doctor_start_shift') ? 'is-invalid' : ''); ?>" name="doctor_start_shift" placeholder="<?php echo e(meta('doctor_start_shift', $lang) ?? __('appointments.doctor_start_shift')); ?>" value='<?php echo e(old("doctor_start_shift", $appointment->doctor_start_shift ?? null)); ?>'/>
            </div>
            <div class="form-group col-lg-4">
                <label><?php echo e(meta('doctor_end_shift', $lang) ?? __('appointments.doctor_end_shift')); ?> </label>
                <input type="time" class="form-control <?php echo e($errors->has('doctor_end_shift') ? 'is-invalid' : ''); ?>" name="doctor_end_shift" placeholder="<?php echo e(meta('doctor_end_shift', $lang) ?? __('appointments.doctor_end_shift')); ?>" value='<?php echo e(old("doctor_end_shift", $appointment->doctor_end_shift ?? null)); ?>'/>
            </div>


















        <div class="text-center mt-5 col-12">
            <button class="butn add_button"><span><?php echo e(__('dashboard.save')); ?></span></button>
        </div>
    </form>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('inner_js'); ?>
    <!-- Editor JS files -->
    <script src="<?php echo e(asset('/assets/admin/js/lib/tinymce.min.js')); ?>"></script>
    
    <script>
        let route_prefix = "<?php echo e(url(config('lfm.prefix'))); ?>",
            url = "<?php echo e(url('/')); ?>/",
            currentLanguage = "<?php echo e($lang); ?>",
            imagePath = "<?php echo e(asset('')); ?>",
            inputName = null;
        let imgSrc = "<?php echo e(asset('assets/admin/images/file-icon.png')); ?>";
    </script>

    <script src="<?php echo e(asset('assets/admin/js/editor.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/lfm.js')); ?>"></script>
    <script>


        sendAjax('.add_button', '.add_form');

        let getDoctorsRoute = "<?php echo e(route('appointments.getDoctors')); ?>",
            selectTypeTitle = "<?php echo e(__('appointments.doctor_id')); ?>";

        $('select[name="service_id"]').change(async function(){

            let doctorSelector = $('select[name="doctor_id"]');

            doctorSelector.html('');

            let thisVal = $(this).val();

            if(thisVal === ''){
                return false;
            }

            let data = {service_id: thisVal},
                url = getDoctorsRoute,
                method = 'get';

            const response=await ajax({
                url,
                data,
                dataType: 'json',
                method
            });

            if (response.url){
                window.location.href = response.url;
            }

            if (response.doctors.length){
                doctorSelector.html(`<option value="">${selectTypeTitle}</option>`);
                for(let doctor of response.doctors){
                    doctorSelector.append(`<option value="${doctor.id}">${doctor.name}</option>`)
                }
            }

        });



    </script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('admin.layouts.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\foot\resources\views/admin/appointments/form.blade.php ENDPATH**/ ?>