<?php $__env->startSection('content'); ?>
<div class="side-title">
    <h3><?php echo e($head ?? ''); ?></h3>
</div>

<div class="border-item">
    <form class="form-row add_form" method="post" action="<?php echo e($action); ?>" enctype="multipart/form-data">
        <?php if($page ?? ''  && $page->id): ?>
            <?php echo method_field('PUT'); ?>
        <?php endif; ?>
        <?php echo csrf_field(); ?>

        <?php if($page->id == 1): ?>
        <div class="form-group col-lg-12 video_added_type">
            <label><?php echo e(meta('video_added_type', $lang) ?? __('pages.video_added_type')); ?> </label>
            <select name="video_added_type" class="form-control <?php echo e($errors->has('video_added_type') ? 'is-invalid' : ''); ?>">
                <option value=""><?php echo e(__('pages.video_added_type')); ?></option>
                <option <?php echo e(($page->meta['video_url'] ?? null) ? 'selected' : ''); ?> value="url"><?php echo e(__('pages.video_url')); ?></option>
                <option <?php echo e(($page->meta['video'] ?? null) ? 'selected' : ''); ?> value="video"><?php echo e(__('pages.video')); ?></option>
            </select>
        </div>
        <div class="form-group video_url col-lg-12 <?php echo e(($page->meta['video_url'] ?? null) ? '' : 'd-none'); ?>">
            <label><?php echo e(meta('video_url', $lang) ?? __('pages.video_url')); ?> </label>
            <input type="url" class="form-control <?php echo e($errors->has('video_url') ? 'is-invalid' : ''); ?>" name="video_url" placeholder="<?php echo e(meta('video_url', $lang) ?? __('pages.video_url')); ?>" value='<?php echo e(old("video_url", $page->meta['video_url'] ?? null)); ?>'/>
        </div>
        <?php endif; ?>

        <?php $__currentLoopData = languages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="form-group col">
            <label><?php echo e(meta('page_title', $language->local) ?? __('pages.page_title')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
            <input type="text" class="form-control <?php echo e($errors->has('page_title_'.$language->local) ? 'is-invalid' : ''); ?>" name="page_title_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('page_title', $language->local) ?? __('pages.page_title')); ?>" value='<?php echo e(old("page_title_{$language->local}", $page[$language->local]->page_title ?? null)); ?>'/>
        </div>

        <?php if($page[$language->local]->title ?? null): ?>
            <div class="form-group col">
                <label><?php echo e(meta('title', $language->local) ?? __('pages.title')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                <input type="text" class="form-control <?php echo e($errors->has('title_'.$language->local) ? 'is-invalid' : ''); ?>" name="title_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('title', $language->local) ?? __('pages.title')); ?>" value='<?php echo e(old("title_{$language->local}", $page[$language->local]->title ?? null)); ?>'/>
            </div>
        <?php endif; ?>
        <?php if($page[$language->local]->description): ?>
            <div class="form-group col-lg-12">
                <label><?php echo e(meta('description', $language->local) ?? __('pages.description')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                <textarea id="description_<?php echo e($language->local); ?>" name="description_<?php echo e($language->local); ?>" class="form-control my-editor <?php echo e($errors->has('description_'.$language->local) ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(meta('description', $language->local) ?? __('pages.description')); ?>"><?php echo e(old("description_{$language->local}", $page[$language->local]->description ?? null)); ?></textarea>
            </div>
        <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <?php if($page->id == 8): ?>
            <?php $__currentLoopData = languages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="form-group col-lg-3">
                <label><?php echo e(meta('users', $language->local) ?? __('pages.users')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                <input type="text" class="form-control <?php echo e($errors->has('title_'.$language->local) ? 'is-invalid' : ''); ?>" name="users_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('users', $language->local) ?? __('pages.users')); ?>" value='<?php echo e(old("users_{$language->local}", $page->meta['users'][$language->local] ?? null)); ?>'/>
            </div>
            <div class="form-group col-lg-3">
                <label><?php echo e(meta('services', $language->local) ?? __('pages.services')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                <input type="text" class="form-control <?php echo e($errors->has('title_'.$language->local) ? 'is-invalid' : ''); ?>" name="services_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('services', $language->local) ?? __('pages.services')); ?>" value='<?php echo e(old("services_{$language->local}", $page->meta['services'][$language->local] ?? null)); ?>'/>
            </div>
            <div class="form-group col-lg-3">
                <label><?php echo e(meta('employees', $language->local) ?? __('pages.employees')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                <input type="text" class="form-control <?php echo e($errors->has('title_'.$language->local) ? 'is-invalid' : ''); ?>" name="employees_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('employees', $language->local) ?? __('pages.employees')); ?>" value='<?php echo e(old("employees_{$language->local}", $page->meta['employees'][$language->local] ?? null)); ?>'/>
            </div>
            <div class="form-group col-lg-3">
                <label><?php echo e(meta('projects', $language->local) ?? __('pages.projects')); ?> <?php echo e(count($languages) > 1 ? "({$language->name})" : ''); ?> </label>
                <input type="text" class="form-control <?php echo e($errors->has('title_'.$language->local) ? 'is-invalid' : ''); ?>" name="projects_<?php echo e($language->local); ?>" placeholder="<?php echo e(meta('projects', $language->local) ?? __('pages.projects')); ?>" value='<?php echo e(old("projects_{$language->local}", $page->meta['projects'][$language->local] ?? null)); ?>'/>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <div class="form-group col-lg-3">
                    <label><?php echo e(meta('statistics', $lang) ?? __('pages.statistics')); ?> </label>
                    <input type="text" class="form-control <?php echo e($errors->has('statistics') ? 'is-invalid' : ''); ?>" name="statistics[]" placeholder="<?php echo e(meta('statistics', $lang) ?? __('pages.statistics')); ?>" value='<?php echo e(old("statistics", $page->meta['users']['statistics'] ?? null)); ?>'/>
                </div>
                <div class="form-group col-lg-3">
                    <label><?php echo e(meta('statistics', $lang) ?? __('pages.statistics')); ?> </label>
                    <input type="text" class="form-control <?php echo e($errors->has('statistics') ? 'is-invalid' : ''); ?>" name="statistics[]" placeholder="<?php echo e(meta('statistics', $lang) ?? __('pages.statistics')); ?>" value='<?php echo e(old("statistics", $page->meta['services']['statistics'] ?? null)); ?>'/>
                </div>
                <div class="form-group col-lg-3">
                    <label><?php echo e(meta('statistics', $lang) ?? __('pages.statistics')); ?> </label>
                    <input type="text" class="form-control <?php echo e($errors->has('statistics') ? 'is-invalid' : ''); ?>" name="statistics[]" placeholder="<?php echo e(meta('statistics', $lang) ?? __('pages.statistics')); ?>" value='<?php echo e(old("statistics", $page->meta['employees']['statistics'] ?? null)); ?>'/>
                </div>
                <div class="form-group col-lg-3">
                    <label><?php echo e(meta('statistics', $lang) ?? __('pages.statistics')); ?> </label>
                    <input type="text" class="form-control <?php echo e($errors->has('statistics') ? 'is-invalid' : ''); ?>" name="statistics[]" placeholder="<?php echo e(meta('statistics', $lang) ?? __('pages.statistics')); ?>" value='<?php echo e(old("statistics", $page->meta['projects']['statistics'] ?? null)); ?>'/>
                </div>

                <div class="form-group col-lg-12">
                    <label><?php echo e(meta('banner_url', $lang) ?? __('pages.banner_url')); ?> </label>
                    <input type="url" class="form-control <?php echo e($errors->has('banner_url') ? 'is-invalid' : ''); ?>" name="banner_url" placeholder="<?php echo e(meta('banner_url', $lang) ?? __('pages.banner_url')); ?>" value='<?php echo e(old("banner_url", $page->meta['banner_url'] ?? null)); ?>'/>
                </div>

        <?php endif; ?>





        
        <?php if(in_array($page->id, [1,2,3,4,5,6,7,8])): ?>
            <div class="form-group col-lg-6">
                <label><?php echo e(meta('image', $lang) ?? __('pages.image')); ?> </label>
                <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="<?php echo e(old("image", $page->image ?? "")); ?>"/>

                <div class="photos image_main_photo <?php echo e(old('image', $page->image ?? '') ? ' wow fadeInUp' : 'hide'); ?>">
                    <div class="col-lg-12">
                        <div class="items">
                            <div class="img">
                                <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".image_pick_button">
                                    <img src="<?php echo e(asset(old('image', $page->image ?? ''))); ?> "  id="image_holder" class="image_holder"/>
                                </a>
                            </div>
                            <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".image_main_photo" data-show=".image_pick_button"><i class="fas fa-times"></i></a>
                        </div>
                    </div>
                </div>

                <div class="clearfix"></div>
                <span class="input-group-btn image_pick_button <?php echo e(old('image', $page->image ?? '') ? 'hide' : ''); ?> ">
            <a id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" data-show=".image_main_photo" data-hide=".image_pick_button" class="lfm btn btn-primary text-light">
                <i class="fas fa-camera-retro"></i> <?php echo e(__('dashboard.choose')); ?>

            </a>
        </span>
            </div>

            
            <div class="form-group col-lg-6 video_container <?php echo e(($page->meta['video'] ?? null) ? '' : 'd-none'); ?>">
                <label><?php echo e(meta('video', getCurrentLocale()) ?? __('galleries.video')); ?> </label>
                <input id="video_thumbnail" class="video_thumbnail" type="hidden" name="video" value="<?php echo e(old("video", $page->meta['video'] ?? "")); ?>"/>

                <div class="photos main_video <?php echo e(old('video', $page->meta['video'] ?? '') ? ' wow fadeInUp' : 'hide'); ?>">
                    <div class="col-lg-12">
                        <div class="items">
                            <div class="img">
                                <a href="#" id="lfm" data-input=".video_thumbnail" data-preview=".video_holder" class="lfm" data-hide=".pick_button">
                                    <img src="<?php echo e(asset('assets/web/images/icons/video.png')); ?>"  id="video_holder" class="video_holder"/>
                                </a>
                            </div>
                            <a href="#" class="showHide resetImage close" data-empty=".video_thumbnail" data-hide=".main_video" data-show=".video_pick_button"><i class="fas fa-times"></i></a>
                        </div>
                    </div>
                </div>

                <div class="clearfix"></div>
                <span class="input-group-btn video_pick_button <?php echo e(old('video', $page->meta['video'] ?? '') ? 'hide' : ''); ?> ">
                    <a id="lfm" data-input=".video_thumbnail" data-preview=".video_holder" data-show=".main_video" data-hide=".video_pick_button" class="lfm btn btn-primary text-light">
                        <i class="fas fa-camera-retro"></i> <?php echo e(__('dashboard.choose')); ?>

                    </a>
                </span>
            </div>
            

        <?php endif; ?>
        

        <div class="text-center mt-5 col-12">
            <button class="butn add_button"><span><?php echo e(__('dashboard.save')); ?></span></button>
        </div>
    </form>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('inner_js'); ?>
    <script src="<?php echo e(asset('/assets/admin/js/lib/tinymce.min.js')); ?>"></script>
    
    <script>
        let route_prefix = "<?php echo e(url(config('lfm.prefix'))); ?>",
            url = "<?php echo e(url('/')); ?>/",
            currentLanguage = "<?php echo e($lang); ?>",
            imagePath = "<?php echo e(asset('')); ?>",
            videoPath = "<?php echo e(asset('assets/web/images/icons/video.png')); ?>",
            inputName = null;
        let imgSrc = "<?php echo e(asset('assets/admin/images/file-icon.png')); ?>";
    </script>
    <script src="<?php echo e(asset('assets/admin/js/editor.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/lfm.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/articles.js')); ?>"></script>


    <script>

        sendAjax('.add_button', '.add_form');

        $('select[name="video_added_type"]').change(function () {

            let thisVal = $(this).val();

            if(thisVal === 'video'){
                $('.video_container').removeClass('d-none');
                $('.video_url').addClass('d-none');
                $('input[name="video_url"]').val(null);
            }

            if(thisVal === 'url'){
                $('.video_url').removeClass('d-none');
                $('.video_container').addClass('d-none');
                $('.video_container a.close').trigger('click');
            }

            if(!thisVal){
                $('.video_container').addClass('d-none');
                $('.video_container a.close').trigger('click');
                $('.video_url').addClass('d-none');
                $('input[name="video_url"]').val(null);
            }

        });

        $('.add_properties').click(function (e) {
            e.preventDefault();
            let counter = (Math.random()*100000).toString(20).replace('.', '_');
            let serviceDiv = `
                <div class="form-group col-lg-12 card deleted_property property_card">
                    <label><?php echo e(__('pages.properties')); ?></label>
                   <div class="row">
                   <div class="form-group col-md-12 d-flex justify-content-end">
                   <a href="#" class="btn btn-danger delete_property mr-3"><i class="fa fa-times"></i></a>
                   </div>
                    <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="form-group col-md-12">
                            <input type="text" name="properties_<?php echo e($language->local); ?>[]" placeholder="<?php echo e(__('pages.property_title') . ' ' . "($language->name)"); ?>" class="form-control" value=""/>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>`;

            $('.property_container').append(serviceDiv);

        });

        $(document).on('click', '.delete_property', function (e) {
            e.preventDefault();
            $(this).parents('.deleted_property').remove();
        });

        $('body').on('DOMNodeInserted', '.properties_container', function(e) {
            if ($(e.target).find('.lfm')) {
                $('.lfm').filemanager('image', {prefix: route_prefix});
            }
        });

    </script>

<?php $__env->stopSection(); ?>




<?php echo $__env->make('admin.layouts.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp\www\t-connect\resources\views/admin/pages/form.blade.php ENDPATH**/ ?>