<?php

//use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use App\Appointment;
use App\Helpers\QrCode;
use App\Jobs\SendBookingMessageJob;
use App\Reservation;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Route;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;
use Salla\ZATCA\GenerateQrCode;
use Salla\ZATCA\Tags\InvoiceDate;
use Salla\ZATCA\Tags\InvoiceTaxAmount;
use Salla\ZATCA\Tags\InvoiceTotalAmount;
use Salla\ZATCA\Tags\Seller;
use Salla\ZATCA\Tags\TaxNumber;

/**
 * Localization Group
 */

Route::group(['prefix' => LaravelLocalization::setLocale()], function(){

    Route::get('/test', function (){

        \Illuminate\Support\Facades\Artisan::call('cache:clear');
        \Illuminate\Support\Facades\Artisan::call('config:clear');

        $array = [1,2,3,4,5,6,7,8,9];

        shuffle($array);
        dd(array_slice($array, 0, 3));
    });


    Route::group(['namespace' => 'Web','middleware' => [ 'checkWebSiteEnabled', 'WebsiteVisitorCount'] ], function () {

        Route::get('/', function (){
           return redirect('admin/login');
        });
//        Route::get('/', 'HomeController@index')->name('home');
//        Route::get('/get-gallery-media', 'HomeController@getGalleryMedia')->name('getGalleryMedia');
//
//        Route::get('about-us', 'AboutUsController@index')->name('aboutUs');
//
//        Route::group(['prefix' => 'service'], function (){
//            Route::get('/', 'ServiceController@index')->name('service.index');
//            Route::get('/{service}', 'ServiceController@show')->name('service.show');
//        });
//
//
//        Route::get('galleries', 'GalleryController@index')->name('gallery.index');
//        Route::get('pages/{type}', 'PageController@index')->name('pages');
//
//
//        Route::get('/contact-us', 'VisitorMessageController@index')->name('contact.index');
//        Route::post('/contact-us', 'VisitorMessageController@store')->name('contact.store');




    });


    /**
     * this route for the central admin and central super admin to enable them to use this website
     */
    Route::get('/login/{admin_token}', 'Auth\LoginController@superAdminLogin')->name('superAdminLogin');

    /**
     * Authentication routes , and Authentication user routs
     */
//	Auth::routes();

    /**
     * Admin Routes
     */
    Route::group([ 'prefix'=> 'admin', 'namespace' => 'Admin'], function () {

        Route::get('/login', 'LoginController@index');
        Route::post('/login', 'LoginController@authenticate')->name('admin_login');

        Route::group([ 'middleware' => ['admin_auth']], function () {
            Route::post('save-token', 'UserController@storeDeviceToken')->name('users.saveToken');

            Route::get('/', 'DashboardController@index')->name('dashboard');

            Route::post('/logout', 'LoginController@logout')->name('admin_logout');

            Route::group([ 'middleware' => ['checkRole']], function () {


                Route::put('/categories/restore/{id}', 'CategoryController@restore')->name('categories.restore');
                Route::put('/categories/restore', 'CategoryController@restoreAll')->name('categories.restoreAll');
                Route::delete('/categories', 'CategoryController@destroyAll')->name('categories.destroyAll');
                Route::get('/categories/grid', 'CategoryController@grid')->name('categories.grid');
                Route::resource('/categories', 'CategoryController');

                Route::put('/tags/restore/{id}', 'TagController@restore')->name('tags.restore');
                Route::put('/tags/restore', 'TagController@restoreAll')->name('tags.restoreAll');
                Route::delete('/tags', 'TagController@destroyAll')->name('tags.destroyAll');
                Route::get('/tags/grid', 'TagController@grid')->name('tags.grid');
                Route::resource('/tags', 'TagController');

                Route::put('/articles/restore/{id}', 'ArticleController@restore')->name('articles.restore');
                Route::put('/articles/restore', 'ArticleController@restoreAll')->name('articles.restoreAll');
                Route::delete('/articles', 'ArticleController@destroyAll')->name('articles.destroyAll');
                Route::get('/articles/grid', 'ArticleController@grid')->name('articles.grid');
                Route::resource('/articles', 'ArticleController');

                Route::put('/services/restore/{id}', 'ServiceController@restore')->name('services.restore');
                Route::put('/services/restore', 'ServiceController@restoreAll')->name('services.restoreAll');
                Route::delete('/services', 'ServiceController@destroyAll')->name('services.destroyAll');
                Route::get('/services/grid', 'ServiceController@grid')->name('services.grid');
                Route::resource('/services', 'ServiceController');

                Route::put('/projects/restore/{id}', 'ProjectController@restore')->name('projects.restore');
                Route::put('/projects/restore', 'ProjectController@restoreAll')->name('projects.restoreAll');
                Route::delete('/projects', 'ProjectController@destroyAll')->name('projects.destroyAll');
                Route::get('/projects/grid', 'ProjectController@grid')->name('projects.grid');
                Route::resource('/projects', 'ProjectController');

                Route::put('/galleries/restore/{id}', 'GalleryController@restore')->name('galleries.restore');
                Route::put('/galleries/restore', 'GalleryController@restoreAll')->name('galleries.restoreAll');
                Route::delete('/galleries', 'GalleryController@destroyAll')->name('galleries.destroyAll');
                Route::get('/galleries/grid', 'GalleryController@grid')->name('galleries.grid');
//                Route::get('/galleries/get-categories', 'GalleryController@getCategories')->name('galleries.getCategories');
                Route::resource('/galleries', 'GalleryController');

                Route::put('/careers/restore/{id}', 'CareerController@restore')->name('careers.restore');
                Route::put('/careers/restore', 'CareerController@restoreAll')->name('careers.restoreAll');
                Route::delete('/careers', 'CareerController@destroyAll')->name('careers.destroyAll');
                Route::get('/careers/grid', 'CareerController@grid')->name('careers.grid');
                Route::resource('/careers', 'CareerController');

                Route::put('/careerApplications/restore/{id}', 'CareerApplicationController@restore')->name('careerApplications.restore');
                Route::put('/careerApplications/restore', 'CareerApplicationController@restoreAll')->name('careerApplications.restoreAll');
                Route::delete('/careerApplications', 'CareerApplicationController@destroyAll')->name('careerApplications.destroyAll');
                Route::get('/careerApplications/grid', 'CareerApplicationController@grid')->name('careerApplications.grid');
                Route::resource('/careerApplications', 'CareerApplicationController')->only(['index', 'edit', 'destroy']);


                Route::put('/partners/restore/{id}', 'PartnerController@restore')->name('partners.restore');
                Route::put('/partners/restore', 'PartnerController@restoreAll')->name('partners.restoreAll');
                Route::delete('/partners', 'PartnerController@destroyAll')->name('partners.destroyAll');
                Route::get('/partners/grid', 'PartnerController@grid')->name('partners.grid');
                Route::resource('/partners', 'PartnerController');

                Route::put('/reviews/restore/{id}', 'ReviewController@restore')->name('reviews.restore');
                Route::put('/reviews/restore', 'ReviewController@restoreAll')->name('reviews.restoreAll');
                Route::delete('/reviews', 'ReviewController@destroyAll')->name('reviews.destroyAll');
                Route::get('/reviews/grid', 'ReviewController@grid')->name('reviews.grid');
//                Route::get('/reviews/activeRoomEvaluate/{roomEvaluate}', 'ReviewController@activeRoomEvaluate')->name('reviews.activeRoomEvaluate');
                Route::resource('/reviews', 'ReviewController');

                Route::get('/pages/grid', 'PageController@grid')->name('pages.grid');
                Route::resource('/pages', 'PageController')->only(['index', 'edit', 'update']);

                Route::put('/visitorMessages/restore/{id}', 'VisitorMessageController@restore')->name('visitorMessages.restore');
                Route::put('/visitorMessages/restore', 'VisitorMessageController@restoreAll')->name('visitorMessages.restoreAll');
                Route::delete('/visitorMessages', 'VisitorMessageController@destroyAll')->name('visitorMessages.destroyAll');
                Route::get('/visitorMessages/grid', 'VisitorMessageController@grid')->name('visitorMessages.grid');
                Route::resource('/visitorMessages', 'VisitorMessageController');

//                Route::put('/newsletters/restore/{id}', 'NewsletterController@restore')->name('newsletters.restore');
//                Route::put('/newsletters/restore', 'NewsletterController@restoreAll')->name('newsletters.restoreAll');
//                Route::delete('/newsletters', 'NewsletterController@destroyAll')->name('newsletters.destroyAll');
//                Route::get('/newsletters/grid', 'NewsletterController@grid')->name('newsletters.grid');
//                Route::get('/newsletters/mailsList', 'NewsletterController@mailsList')->name('newsletters.mailsList');
//                Route::get('/newsletters/mailsListGrid', 'NewsletterController@mailsListGrid')->name('newsletters.mailsListGrid');
//                Route::get('/newsletters/mailsListMore/{id}', 'NewsletterController@mailsListMore')->name('newsletters.mailsListMore');
//                Route::resource('/newsletters', 'NewsletterController');

                Route::put('/users/restore/{id}', 'UserController@restore')->name('users.restore');
                Route::put('/users/restore', 'UserController@restoreAll')->name('users.restoreAll');
                Route::delete('/users', 'UserController@destroyAll')->name('users.destroyAll');
                Route::get('/users/grid', 'UserController@grid')->name('users.grid');
                Route::resource('/users', 'UserController');

                Route::get('/settings', 'SettingController@index')->name('settings.index');
                Route::post('/settings', 'SettingController@store')->name('settings.store');
                Route::post('/modules-settings', 'SettingController@modules')->name('settings.modules');


            });  // End Role Routes


            Route::resource('/languages', 'LanguageController');
            // Route::post('/languages/{id}', 'LanguageController@update')->name('languages');

        }); // End Authenticated Admin routes
    }); // End Admin Routes

});
