@extends('web.layouts.container')

@section('content')
    <section class="services-sec section">
        <div class="container">
            <div class="row">
                @if(count($services))

                    @foreach($services as $service)
                    <div class="col-lg-4 col-md-6">
                    <div class="serv_card">
                        <a href="{{route('service.show', $service->id)}}">
                            <img src="{{asset($service->image)}}" alt="" class="sec-img serv_img"/>
                        </a>
                        <div class="card-body">
                            <a href="{{route('service.show', $service->id)}}" class="title fs-5 fw-bold ">{{$service->name}}</a>
                            <p class="p">{{wordLimit(stripText($service->main_section['desc_'.$lang]), 16)}}</p>
                            <a href="{{route('booking.bookingForm', $service->id)}}" class="butn primary_butn m-auto">{{__('services.make_appointment')}}</a>
                        </div>
                    </div>
                </div>
                    @endforeach
                @endif
            </div>
            <div class="pagination-wrapper mt-5" >
                <nav aria-label="Page navigation example">
                    <ul class="pagination justify-content-center">
                        {{$services->links()}}
                    </ul>
                </nav>
            </div>
        </div>
    </section>
@endsection

@section('inner_js')
    <script>

    </script>
@endsection
