@extends('web.layouts.container')

@section('content')


    <section class="room_det_pg inner_pg section pt-0">
        <div class="container">
            <div class="content content_box mt-0">
                <div class="rooms_content">
                    <div class="row gx-5">
                        <div class="col-lg-7">
                            <div class="main_slider">
                                <span class="status_btn text-white bg-{{$room->room_status ? 'success' : 'danger'}}"> {{$room->room_status ? __('rooms.available') : __('rooms.unavailable')}} </span>
                                <div class="swiper-container">
                                    <div class="swiper-wrapper">
                                        @if(is_array($room->room_slider_meta) && count($room->room_slider_meta))
                                            @foreach($room->room_slider_meta as $sliderMeta)
                                                <div class="swiper-slide">
                                                    <div class="swiper-slide-inner" data-swiper-parallax="60%">
                                                        <div class="img">
                                                            <a href="{{asset($sliderMeta['image'])}}" class="img_back d-block h-100" data-fancybox="main-slider">
                                                                <img src="{{asset($sliderMeta['image'])}}" alt="" class="img_back">
                                                            </a>
                                                            @if($sliderMeta['url'] ?? null)
                                                            <span class="vid_overlay"></span>
                                                                <a class="button is-play" data-fancybox href="{{$sliderMeta['url']}}">
                                                                    <div class="button-outer-circle has-scale-animation"></div>
                                                                    <div class="button-outer-circle has-scale-animation has-delay-short"></div>
                                                                    <div class="button-icon is-play">
                                                                        <svg height="100%" width="100%" fill="#fff"><polygon class="triangle" points="5,0 30,15 5,30" viewBox="0 0 30 15"></polygon><path class="path" d="M5,0 L30,15 L5,30z" fill="none" stroke="#fff" stroke-width="1"></path></svg>
                                                                    </div>
                                                                </a>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach
                                        @endif
                                    </div>
                                </div>
                                <div class="arrows">
                                    <div class="swiper-button-next"></div>
                                    <div class="swiper-button-prev"></div>
                                </div>
                            </div>
                            <div class="info mt-4">
                                <div class="d-lg-flex justify-content-between align-items-center">
                                    <h3 class="title">{{$room->name}}</h3>
                                    <a href="{{route('room.roomReservationForm', $room->id)}}" class="butn primary_border_butn mt-0 px-4 py-2 mb-4 mb-lg-0"> <span>{{__('main.reservation_request')}}</span> </a>
                                </div>
                                <div class="m_inf mt-2">
                                    <small class="label me-3"> <span><i class="bi bi-info-circle me-1 color-primary"></i> {{__('rooms.room_type_id')}} : </span> {{$room->roomTypeName}} </small>
                                    <small class="label me-3"> <span> <i class="bi bi-geo-alt me-1 color-primary"></i> {{__('rooms.branch_id')}} : </span> {{$room->branchName}} </small>
                                    <small class="label"> <span> <i class="bi bi-people me-1 color-primary"></i> {{__('rooms.person_count')}} : </span> {{$room->person_count . ' ' . __('rooms.person')}} </small>
                                </div>
                                <div class="title d-flex mt-4 align-items-center"> <strong> {{__('rooms.room_price')}} : </strong> <h4 class="color-primary ms-3"> {{$room->room_price . ' ' . __('rooms.sar')}}  </h4></div>
                                <div class="text mt-3">{!! $room->description !!}</div>
                            </div>
                        </div>
                        <div class="col-lg-5">
                            <div class="box_item mb-5 mt-5 mt-lg-0">
                                <h5 class="title"> {{__('rooms.rate_avg')}} </h5>
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="inf">
                                        <span class="stars color-primary">
                                            @if($room->rate)
                                                @for($i = 1; $i <= $room->rate; $i++)
                                                    <i class="far fa-star"></i>
                                                @endfor
                                                @else
                                            {{__('rooms.no_evaluates')}}
                                            @endif
                                        </span>
                                        <small class="ms-lg-4 color-gray2">  {{$ratingLevel}} ( {{$ratingCounts . ' ' . __('rooms.evaluates')}} ) </small>
                                    </div>
                                    <a href="#0" class="text-decoration-underline color-primary" data-bs-toggle="modal" data-bs-target="#rated_modal"> {{__('rooms.details')}} </a>
                                </div>
                            </div>
                            <div class="box_item mb-4">
                                <h5 class="title"> {{__('rooms.contact_info')}} </h5>
                                <p class="mb-2"> <i class="bi bi-phone me-1"></i> : {{$room->phone}} </p>
                                <p class="mb-2"> <i class="bi bi-envelope me-1"></i> : {{$room->email}} </p>
                                <p> <i class="bi bi-geo-alt me-1"></i> :  <a href="#0" data-bs-toggle="modal" data-bs-target="#map_modal" class="color-primary text-decoration-underline"> {{__('rooms.view_on_map')}} </a> </p>
                            </div>
                            <div class="room_features">
                                <div class="room_features_slider">
                                    <div class="swiper-container overflow-hidden position-relative pb-5">
                                        <div class="swiper-wrapper">
                                            @if(count($roomServices))
                                                @foreach($roomServices as $roomService)
                                                    <div class="swiper-slide">
                                                        <div class="box_item text-center">
                                                            <div class="icon">
                                                                <img src="{{asset($roomService->image)}}" alt="">
                                                            </div>
                                                            <p> {{$roomService->name}} </p>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            @endif
                                        </div>
                                        <div class="swiper-pagination"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- ---------- testimonials   ----------- -->
    <section class="testimonials section">
        <div class="container">
            <div class="section-head text-center mb-5">
                <h2 class="pg_title  title"> {{__('rooms.room_evaluates')}}  </h2>
            </div>
            <div class="swiper-container position-relative pb-5">
                <div class="swiper-wrapper">
                    @if(count($roomReviews))
                        @foreach($roomReviews as $roomReview)
                            <div class="swiper-slide">
                                <div class="test_card">
                                    <div class="row gx-0 align-items-center">
                                        <div class="col-lg-3">
                                            <div class="img_side">
                                                <div class="img">
                                                    <img src="{{asset('assets/web/images/logo.png')}}" alt="">
                                                </div>
                                                <div class="inf">
                                                    <h6 class="title">{{$roomReview->name}}</h6>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-9">
                                            <div class="info_side">
                                                <?php
                                                /** @var TYPE_NAME $roomReview */
                                                $average = ($roomReview->reception_evaluation + $roomReview->safety_evaluation + $roomReview->room_evaluation + $roomReview->food_evaluation)/4;
                                                $average = ceil($average);
                                                ?>
                                                <div class="stars">
                                                    @for($i = 1; $i <= $average; $i++)
                                                        <i class="far fa-star"></i>
                                                    @endfor
                                                </div>
                                                <div class="text">{{$roomReview->evaluate_text}}</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                        @else
                        <div style="background-color: #cd9b39" class="alert text-center col-lg-12">{{__('rooms.no_evaluates')}}</div>
                    @endif
                </div>
                <div class="swiper-pagination"></div>
            </div>
            <div class="btns d-flex mt-5 justify-content-center text-center">
                <a href="#" class="butn primary_border_butn me-4"  data-bs-toggle="modal" data-bs-target="#addRate_modal">
                    <span> <i class="bi bi-pen me-2"></i>  {{__('rooms.add_evaluate')}} </span>
                </a>
                <a href="#" class="butn primary_border_butn" data-bs-toggle="modal" data-bs-target="#report_modal">
                    <span> <i class="bi bi-info-square me-2"></i> {{__('rooms.add_complaint')}} </span>
                </a>
            </div>
        </div>
    </section>


    {{---------------------------------------------- Modals block --------------------------------------}}

    <div class="modal rated_modal fade" id="rated_modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl">
            <div class="modal-content">
                <div class="modal-body ">
                    <h2 class="title text-center mb-5"> {{__('rooms.rate_avg')}}</h2>
                    <div class="all_rated d-flex align-items-center mb-4">
                        <span class="num">{{$room->rate ? $room->rate : 0}}</span>
                        <p class="rate-title mb-0">
                            <b>{{$ratingLevel}}</b> <br>
                            {{$ratingCounts . ' ' . __('rooms.evaluates')}}
                        </p>
                    </div>
                    <div class="row mt-5">
                        <div class="col-md-6">
                            <div class="data-group d-flex align-items-center">
                                <h6 class="title mb-0"><b>{{__('roomEvaluates.reception_evaluation')}}</b></h6>
                                <div class="stars">
                                    <i class="fas fa-star {{$room->reception_evaluation >= 1 ? 'active' : ''}}"></i>
                                    <i class="fas fa-star {{$room->reception_evaluation >= 2 ? 'active' : ''}}"></i>
                                    <i class="fas fa-star {{$room->reception_evaluation >= 3 ? 'active' : ''}}"></i>
                                    <i class="fas fa-star {{$room->reception_evaluation >= 4 ? 'active' : ''}}"></i>
                                    <i class="fas fa-star {{$room->reception_evaluation >= 5 ? 'active' : ''}}"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="data-group d-flex align-items-center">
                                <h6 class="title mb-0"><b>{{__('roomEvaluates.safety_evaluation')}}</b></h6>
                                <div class="stars">
                                    <i class="fas fa-star {{$room->safety_evaluation >= 1 ? 'active' : ''}}"></i>
                                    <i class="fas fa-star {{$room->safety_evaluation >= 2 ? 'active' : ''}}"></i>
                                    <i class="fas fa-star {{$room->safety_evaluation >= 3 ? 'active' : ''}}"></i>
                                    <i class="fas fa-star {{$room->safety_evaluation >= 4 ? 'active' : ''}}"></i>
                                    <i class="fas fa-star {{$room->safety_evaluation >= 5 ? 'active' : ''}}"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="data-group d-flex align-items-center">
                                <h6 class="title mb-0"><b>{{__('roomEvaluates.room_evaluation')}}</b></h6>
                                <div class="stars">
                                    <i class="fas fa-star {{$room->room_evaluation >= 1 ? 'active' : ''}}"></i>
                                    <i class="fas fa-star {{$room->room_evaluation >= 2 ? 'active' : ''}}"></i>
                                    <i class="fas fa-star {{$room->room_evaluation >= 3 ? 'active' : ''}}"></i>
                                    <i class="fas fa-star {{$room->room_evaluation >= 4 ? 'active' : ''}}"></i>
                                    <i class="fas fa-star {{$room->room_evaluation >= 5 ? 'active' : ''}}"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="data-group d-flex align-items-center">
                                <h6 class="title mb-0"><b>{{__('roomEvaluates.food_evaluation')}}</b></h6>
                                <div class="stars">
                                    <i class="fas fa-star {{$room->food_evaluation >= 1 ? 'active' : ''}}"></i>
                                    <i class="fas fa-star {{$room->food_evaluation >= 2 ? 'active' : ''}}"></i>
                                    <i class="fas fa-star {{$room->food_evaluation >= 3 ? 'active' : ''}}"></i>
                                    <i class="fas fa-star {{$room->food_evaluation >= 4 ? 'active' : ''}}"></i>
                                    <i class="fas fa-star {{$room->food_evaluation >= 5 ? 'active' : ''}}"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                    <button type="button" class="butn primary_border_butn mt-4 py-2 m-auto d-block" data-bs-dismiss="modal"> <span> اغلاق </span> </button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal rated_modal fade add_evaluate_modal" id="addRate_modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl">
            <div class="modal-content p-0">
                <button type="button" class="float_cls" data-bs-dismiss="modal"> <span> <i class="fa-solid fa-xmark"></i> </span> </button>
                <div class="modal-body p-lg-5">
                    <h2 class="title text-center mb-5">{{__('rooms.add_evaluate')}}</h2>
                    <form method="post" action="{{route('room.addEvaluate')}}" class="add_evaluate_form">
                        <div class="row mt-5">
                            <div class="col-lg-6">
                                <div class="data-group d-flex align-items-center">
                                    <h6 class="title mb-0"><b>{{__('roomEvaluates.reception_evaluation')}}</b></h6>
                                    <div class="stars-content">
                                        <div class="star-rating">
                                            <input type="radio" id="5-stars" name="reception_evaluation" value="5" />
                                            <label for="5-stars" class="star">&#9733;</label>
                                            <input type="radio" id="4-stars" name="reception_evaluation" value="4" />
                                            <label for="4-stars" class="star">&#9733;</label>
                                            <input type="radio" id="3-stars" name="reception_evaluation" value="3" />
                                            <label for="3-stars" class="star">&#9733;</label>
                                            <input type="radio" id="2-stars" name="reception_evaluation" value="2" />
                                            <label for="2-stars" class="star">&#9733;</label>
                                            <input type="radio" id="1-star" name="reception_evaluation" value="1" />
                                            <label for="1-star" class="star">&#9733;</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="data-group d-flex align-items-center">
                                    <h6 class="title mb-0"><b>{{__('roomEvaluates.safety_evaluation')}}</b></h6>
                                    <div class="stars-content">
                                        <div class="star-rating">
                                            <input type="radio" id="5-rating2" name="safety_evaluation" value="5" />
                                            <label for="5-rating2" class="star">&#9733;</label>
                                            <input type="radio" id="4-rating2" name="safety_evaluation" value="4" />
                                            <label for="4-rating2" class="star">&#9733;</label>
                                            <input type="radio" id="3-rating2" name="safety_evaluation" value="3" />
                                            <label for="3-rating2" class="star">&#9733;</label>
                                            <input type="radio" id="2-rating2" name="safety_evaluation" value="2" />
                                            <label for="2-rating2" class="star">&#9733;</label>
                                            <input type="radio" id="1-rating2" name="safety_evaluation" value="1" />
                                            <label for="1-rating2" class="star">&#9733;</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="data-group d-flex align-items-center">
                                    <h6 class="title mb-0"><b>{{__('roomEvaluates.room_evaluation')}}</b></h6>
                                    <div class="stars-content">
                                        <div class="star-rating">
                                            <input type="radio" id="5-rating3" name="room_evaluation" value="5" />
                                            <label for="5-rating3" class="star">&#9733;</label>
                                            <input type="radio" id="4-rating3" name="room_evaluation" value="4" />
                                            <label for="4-rating3" class="star">&#9733;</label>
                                            <input type="radio" id="3-rating3" name="room_evaluation" value="3" />
                                            <label for="3-rating3" class="star">&#9733;</label>
                                            <input type="radio" id="2-rating3" name="room_evaluation" value="2" />
                                            <label for="2-rating3" class="star">&#9733;</label>
                                            <input type="radio" id="1-rating3" name="room_evaluation" value="1" />
                                            <label for="1-rating3" class="star">&#9733;</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="data-group d-flex align-items-center">
                                    <h6 class="title mb-0"><b>{{__('roomEvaluates.food_evaluation')}}</b></h6>
                                    <div class="stars-content">
                                        <div class="star-rating">
                                            <input type="radio" id="5-rating4" name="food_evaluation" value="5" />
                                            <label for="5-rating4" class="star">&#9733;</label>
                                            <input type="radio" id="4-rating4" name="food_evaluation" value="4" />
                                            <label for="4-rating4" class="star">&#9733;</label>
                                            <input type="radio" id="3-rating4" name="food_evaluation" value="3" />
                                            <label for="3-rating4" class="star">&#9733;</label>
                                            <input type="radio" id="2-rating4" name="food_evaluation" value="2" />
                                            <label for="2-rating4" class="star">&#9733;</label>
                                            <input type="radio" id="1-rating4" name="food_evaluation" value="1" />
                                            <label for="1-rating4" class="star">&#9733;</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group mb-4 mt-4">
                                    <input name="name" type="text" class="form-control" placeholder="{{__('roomEvaluates.name')}}">
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group mb-4">
                                    <textarea name="evaluate_text" rows="3" class="form-control" placeholder="الرسالة"></textarea>
                                </div>
                            </div>
                        </div>
                    </form>
                    <button type="button" class="butn primary_border_butn mt-4 py-2 m-auto d-block add_evaluate_button"> <span> ارسال </span> </button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal report_modal fade add_complaint_modal" id="report_modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl">
            <div class="modal-content p-0">
                <button type="button" class="float_cls" data-bs-dismiss="modal"> <span> <i class="fa-solid fa-xmark"></i> </span> </button>
                <div class="modal-body p-lg-5">
                    <h2 class="title text-center mb-5">{{__('rooms.add_complaint')}}</h2>
                    <form class="add_complaint_form add_reservation_form" method="post" action="{{route('room.addComplaint')}}" enctype="multipart/form-data">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group mb-4">
                                    <input name="name" type="text" class="form-control" placeholder="{{__('roomComplaints.name')}}">
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group mb-4">
                                    <input name="email" type="email" class="form-control" placeholder="{{__('roomComplaints.email')}}">
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group mb-4">
                                    <input name="phone" type="tel" class="form-control" placeholder="{{__('roomComplaints.phone')}}">
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group mb-4">
                                    <input name="title" type="text" class="form-control" placeholder="{{__('roomComplaints.title')}}">
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group mb-4">
                                    <textarea name="details" rows="4" class="form-control" placeholder="{{__('roomComplaints.details')}}"></textarea>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="uploading_box mb-4">
                                    <div class="input-group">
                                        <span class="input-group-btn">
                                          <div class="btn btn-default browse-button">
                                              <span class="browse-button-text">
                                              <i class="fa fa-folder-open"></i> {{__('roomComplaints.upload')}}</span>
                                              <input type="file" name="id_image"/>
                                          </div>
                                          <button type="button" class="btn btn-default clear-button" style="display:none;">
                                            <span class="fa fa-times"></span> {{__('roomComplaints.delete')}}
                                          </button>
                                        </span>
                                        <input type="text" class="form-control filename" disabled="disabled" placeholder="{{__('roomComplaints.attache_image')}}">
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <button class="butn primary_border_butn text-center add_complaint_button add_reservation_button">
                                    <span> {{__('main.send')}} </span>
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="map_modal" tabindex="-1" aria-labelledby="map_modal" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content p-0">
                <button type="button" class="float_cls" data-bs-dismiss="modal"> <span> <i class="fa-solid fa-xmark"></i> </span> </button>
                <div class="modal-body p-0 map_container">{!! $room->map !!}</div>
            </div>
        </div>
    </div>

@endsection

@section('inner_js')

    <script>

        let roomId = "{{$room->id}}";

        $('.add_evaluate_button').click(async function (e) {
            e.preventDefault();
            $(this).prop('disabled', true);

            let form = $('.add_evaluate_form'),
                data = new FormData(form[0]),
                url = form.attr('action'),
                method = form.attr('method');

            data.append('room_id', roomId);

            const response=await ajax({
                url,
                data,
                dataType: 'json',
                method
            });

            if (response.errors){
                $(this).prop('disabled', false);
                toasterError(response.errors);
            }

            if (response.message){
                $(this).prop('disabled', false);
                toasterSuccess(response.message);
                $('.add_evaluate_modal').modal('hide');
                $('input[name="name"], textarea[name="evaluate_text"]').val('');
            }

        });

        $('.add_complaint_button').click(async function (e) {
            e.preventDefault();
            $(this).prop('disabled', true);

            let form = $('.add_complaint_form'),
                data = new FormData(form[0]),
                url = form.attr('action'),
                method = form.attr('method');

            data.append('room_id', roomId);

            const response=await ajax({
                url,
                data,
                dataType: 'json',
                method
            });

            if (response.errors){
                $(this).prop('disabled', false);
                toasterError(response.errors);
            }

            if (response.message){
                $(this).prop('disabled', false);
                toasterSuccess(response.message);
                $('.add_complaint_modal').modal('hide');
                $('.add_complaint_form input, textarea').val('');
            }

        });

        $(document).ready(function () {
            $('.map_container iframe').attr('width', '100%').attr('height', '450');
            $('.inner_head .container div').removeClass('text-center');
            $('.inner_head .container div h2').addClass('half_r');
        });

    </script>


@endsection
