@if(count($rooms))
<div class="row">
    @foreach($rooms as $room)
        <div class="col-lg-4 list_grid_item">
            <div class="room_item">
                <div class="img">
                    <img src="{{asset($room->image)}}" alt="">
                    <span class="stars">
                        @if($room->rate)
                            @for($i = 1; $i <= $room->rate; $i++)
                                <i class="far fa-star"></i>
                            @endfor
                        @else
                        {{__('rooms.no_evaluates')}}
                        @endif
                    </span>
                </div>
                <div class="info">
                    <h4 class="title">{{$room->name}}</h4>
                    <div class="m_inf mt-2">
                        <small class="label me-3">
                            <span> <i class="bi bi-info-circle me-1 color-primary"></i> {{__('rooms.room_type_id')}} : </span>{{$room->roomTypeName}}
                        </small>
                        <small class="label">
                            <span> <i class="bi bi-geo-alt me-1 color-primary"></i> {{__('rooms.branch_id')}} :</span> {{$room->branchName}}
                        </small>
                    </div>
                    <div class="text mt-4">{{wordLimit(stripText($room->description), 15)}}</div>
                    <a href="{{route('room.show', $room->id)}}" class="mor_btn"> <i class="bi bi-eye me-1"></i> {{__('rooms.see_room')}} </a>
                </div>
            </div>
        </div>
    @endforeach
</div>
<nav aria-label="Page navigation example">
    {{$rooms->links()}}
</nav>
    @else
    <div style="background-color: #cd9b39" class="alert text-center">{{__('rooms.no_data')}}</div>
@endif
