@extends('web.layouts.container')

@section('content')
    <section class="booking_pg disabled_services section">
        <div class="container">
            <div class="content mt-0">
                <div class="ser_card">
                    <div class="info_lg">
                        <form method="post" action="{{route('room.addReservation')}}" class="add_reservation_form" enctype="multipart/form-data">
                            <div class="row w-100 ">
                                <div class="col-lg-6">
                                    <div class="form-group mb-4">
                                        <input type="text" name="name" class="form-control" placeholder="{{__('roomReservations.name')}}">
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group mb-4">
                                        <input style="direction: rtl" type="email" name="email" class="form-control" placeholder="{{__('roomReservations.email')}}">
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group mb-4">
                                        <input style="direction: rtl" type="tel" name="phone" class="form-control" placeholder="{{__('roomReservations.phone')}}">
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="uploading_box mb-4">
                                        <div class="input-group">
                                                <span class="input-group-btn">
                                                  <div class="btn btn-default browse-button">
                                                      <span class="browse-button-text">
                                                      <i class="fa fa-folder-open"></i> {{__('roomReservations.upload')}}</span>
                                                      <input type="file" name="id_image"/>
                                                  </div>
                                                  <button type="button" class="btn btn-default clear-button" style="display:none;">
                                                    <span class="fa fa-times"></span> {{__('roomReservations.delete')}}
                                                  </button>
                                                </span>
                                            <input type="text" class="form-control filename" disabled="disabled" placeholder="{{__('roomReservations.id_image')}}">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group mb-4 select_group">
                                        <select name="branch_id" class="form-control form-select">
                                            <option value="">{{__('roomReservations.branch_id')}}</option>
                                            @if(count($branches))
                                                @foreach($branches as $branch)
                                                    <option value="{{$branch->id}}">{{$branch->name}}</option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group mb-4 select_group">
                                        <select name="room_type_id" class="form-control form-select">
                                            <option value="">{{__('roomReservations.room_type_id')}}</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="rooms_checks col-lg-12">
                                    <h6 class="label mb-3">{{__('roomReservations.select_room')}}</h6>
                                    <div class="row rooms_container"></div>

                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group mb-4">
                                        <label class="label mb-1">{{__('roomReservations.start_date')}}</label>
                                        <input type="text" name="start_date" class="form-control datepicker" placeholder="{{__('roomReservations.start_date')}}" id="">
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group mb-4">
                                        <label class="label mb-1">{{__('roomReservations.end_date')}}</label>
                                        <input type="text" name="end_date" class="form-control datepicker" placeholder="{{__('roomReservations.end_date')}}">
                                        <span class="text-danger d-none end_date_alert">{{__('roomReservations.end_date_validation')}}</span>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group mb-4">
                                        <label class="label mb-1">{{__('roomReservations.days_count')}}</label>
                                        <input type="text" class="form-control days_count" value="" disabled />
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group mb-4">
                                        <label class="label mb-1">{{__('roomReservations.total')}}</label>
                                        <input type="text" class="form-control total" value="" disabled />
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="payment_method">
                                        <label class="label mb-3">{{__('roomReservations.pay_way')}}</label>
                                        <div class="row">
                                            <div class="col-lg col-md-6">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="pay_way" id="paymentMethod1" value="2">
                                                    <label class="form-check-label" for="paymentMethod1">
                                                        <img src="{{asset('assets/web/images/payment_icons/visa_master.png')}}" alt="" class="pay_logo"/>
                                                        <h6 class="title name mb-0">{{__('roomReservations.visa_master')}}</h6>
                                                    </label>
                                                </div>
                                            </div>
                                            @if($showApplePay)
                                                <div class="col-lg col-md-6">
                                                    <div class="form-check">
                                                        <input class="form-check-input" type="radio" name="pay_way" id="paymentMethod5" value="11">
                                                        <label class="form-check-label" for="paymentMethod5">
                                                            <img src="{{asset('assets/web/images/payment_icons/apple_pay.png')}}" alt="" class="pay_logo"/>
                                                            <h6 class="title name mb-0">{{__('roomReservations.apple_pay')}}</h6>
                                                        </label>
                                                    </div>
                                                </div>
                                            @endif
                                            <div class="col-lg col-md-6">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="pay_way" id="paymentMethod6" value="6">
                                                    <label class="form-check-label" for="paymentMethod6">
                                                        <img src="{{asset('assets/web/images/payment_icons/mada.png')}}" alt="" class="pay_logo"/>
                                                        <h6 class="title name mb-0">{{__('roomReservations.mada')}}</h6>
                                                    </label>
                                                </div>
                                            </div>

                                            <div class="col-lg col-md-6">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="pay_way" id="paymentMethod6" value="14">
                                                    <label class="form-check-label" for="paymentMethod6">
                                                        <img src="{{asset('assets/web/images/payment_icons/stc_pay.png')}}" alt="" class="pay_logo"/>
                                                        <h6 class="title name mb-0">{{__('roomReservations.stc_pay')}}</h6>
                                                    </label>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <button type="submit" class="butn primary_border_butn py-3 fw-bold w-100 text-center mt-5 add_reservation_button">
                                        <span> {{__('main.complete_reservation')}} </span>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection

@section('inner_js')

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.13.2/jquery-ui.min.js" integrity="sha512-57oZ/vW8ANMjR/KQ6Be9v/+/h6bq9/l3f0Oc7vn6qMqyhvPd1cvKBRWWpzu0QoneImqr2SkmO4MSqU+RpHom3Q==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>

    <script>

        let getRoomTypesRoute = "{{route('room.getRoomTypes')}}",
            getRoomsRoute = "{{route('room.getRoomsByType')}}",
            roomTypeSelectTitle = "{{__('roomReservations.room_type_id')}}",
            roomSelectTitle = "{{__('roomReservations.room_id')}}";

        $('select[name="branch_id"]').change(async function (e) {
            e.preventDefault();
            let roomTypeSelectBox = $('select[name="room_type_id"]');
            $('.rooms_container').html('');


            roomTypeSelectBox.html('');

            if($(this).val() === ''){
                return false
            }

            let data = {branch_id: $(this).val()},
                url = getRoomTypesRoute,
                method = 'post';

            const response=await ajax({
                url,
                data,
                dataType: 'json',
                method
            });

            if (response.room_types){
                roomTypeSelectBox.html(`<option value="">${roomTypeSelectTitle}</option>`);
                for(let roomType of response.room_types){
                    roomTypeSelectBox.append(`<option value="${roomType.id}">${roomType.name}</option>`)
                }
            }

        });

        $('select[name="room_type_id"]').change(async function (e) {
            e.preventDefault();
            let roomContainer = $('.rooms_container');

            roomContainer.html('');

            if($(this).val() === ''){
                return false
            }

            let data = {room_type_id: $(this).val()},
                url = getRoomsRoute,
                method = 'post';

            const response=await ajax({
                url,
                data,
                dataType: 'html',
                method
            });

            if (response){
                roomContainer.html(response);
            }

        });

        $('.add_reservation_button').click(async function (e) {
            e.preventDefault();
            $(this).prop('disabled', true);

            let form = $('.add_reservation_form'),
                data = new FormData(form[0]),
                url = form.attr('action'),
                method = form.attr('method');

            const response=await ajax({
                url,
                data,
                dataType: 'json',
                method
            });

            if (response.errors){
                $(this).prop('disabled', false);
                toasterError(response.errors);
            }

            if (response.url){
                window.location.href = response.url;
            }

        });



        $(document).on('click', 'input[name="room_id"]', function () {
            checkPriceFunction()
        });

        $('input[name="end_date"]').change(function () {
           checkPriceFunction()
        });

        function checkPriceFunction(){
            let startDate = $('input[name="start_date"]').val(),
                endDate = $('input[name="end_date"]').val(),
                endDateAlert = $('.end_date_alert'),
                daysCount = $('.days_count'),
                total = $('.total'),
                room = $('input[name="room_id"]:checked');
            let roomPrice = room.length  ? room.data('price') : 0;

            if(startDate && endDate){
                if((endDate <= startDate)){
                    endDateAlert.removeClass('d-none');
                    daysCount.val('');
                    total.val('');
                }
                if((endDate > startDate)){
                    endDateAlert.addClass('d-none');
                    startDate = new Date(startDate);
                    endDate = new Date(endDate);
                    let diffTime = Math.abs(endDate - startDate);
                    let diffDays = Math.ceil(diffTime / (1000 * 60 * 60 * 24));
                    daysCount.val(diffDays);
                    total.val(diffDays*roomPrice);
                }

            }
        }


        // Show filename, show clear button and change browse
        //button text when a valid extension file is selected
        $(".browse-button input:file").change(function (){
            $("input[name='id_image']").each(function() {
                var fileName = $(this).val().split('/').pop().split('\\').pop();
                $(".filename").val(fileName);
                $(".browse-button-text").html('<i class="fa fa-refresh"></i> تغيير');
                $(".clear-button").show();
            });
        });

        //actions happening when the button is clicked
        $('.clear-button').click(function(){
            $('.filename').val("");
            $('.clear-button').hide();
            $('.browse-button input:file').val("");
            $(".browse-button-text").html('<i class="fa fa-folder-open"></i> رفع');
        });

    </script>

    <script>
      $( function() {
        $( ".datepicker" ).datepicker();
      } );
  </script>





@endsection
