@extends('web.layouts.container')

@section('content')
    <!-- Start banner-sec -->
    <section class="banner-sec section mt-5">
        <div class="container">
            <div class="text-center">
                <h5 class="subtitle text-uppercase text-white"><b>{{$banner->title}}</b></h5>
                <h1 class="title text-uppercase text-white mb-0"><b>{{$banner->description}}</b></h1>
            </div>
        </div>
        <img src="{{asset($banner->image)}}" alt="" class="bg"/>
    </section>
    <!-- Start falvors-sec -->
    <section class="falvors-sec falvors-pg  section">
        <div class="container">
            <h1 class="title mb-4">{{__('articles.our_flavors')}}</h1>
            <div class="row">
                @if(count($flavors))
                    @foreach($flavors as $flavor)
                        <div class="col-lg-4 col-md-6">
                            <a href="#">
                                <div class="flavor_card">
                                    <img src="{{asset($flavor->image)}}" alt="" class="sec-img"/>
                                    <div class="hvr-content">
                                        <h1 class="title text-white"><b>{{$flavor->name}}</b></h1>
                                        <p class="p text-white col-lg-10 m-auto my-0">{{$flavor->description}}</p>
                                        <div class="profile_data d-flex align-items-enter mt-4 w-100">
                                            <img src="{{asset($flavor->flavorTypeImage)}}" alt="" class="avatar_img me-2"/>
                                            <h6 class="prof_name text-white mb-0 mt-1">{{$flavor->flavorTypeName}}</h6>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        </div>
                    @endforeach
                @endif

            </div>
        </div>
    </section>
@endsection

@section('inner_js')
    <script>
        $('.navbar').addClass('navbar-light')
    </script>
@endsection
