<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <meta name="description" content="{{ $settings['meta_description_'.$lang] }} - {{ $meta_description ?? ($title ?? '') }}" />
    <meta name="keywords" content="{{ $settings['keywords_'.$lang] }} , {{  $keywords ??  ($title ?? '') }}" />
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ $settings['website_name_'.$lang] }} - {{ ($title ?? '') }}</title>
    <link rel="shortcut icon" href="{{ asset($logo ?? 'assets/web/images/logo.svg') }}" type="image/x-icon" />


    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g==" crossorigin="anonymous" referrerpolicy="no-referrer" />    <!--Css Files & Libraries-->
    <link href="https://fonts.googleapis.com/css2?family=El+Messiri:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=El+Messiri:wght@400;500;600;700&display=swap" rel="stylesheet">


          @if (app()->getLocale() == 'en')
             <link rel="stylesheet" href="{{ asset('assets/web/css/lib/bootstrap.min.css') }}" />
         @endif

         @if (app()->getLocale() == 'ar')
            <link rel="stylesheet" href="{{ asset('assets/web/css/lib/bootstrap.rtl.css') }}" />
         @endif


    <link rel="stylesheet" href="{{ asset('assets/web/css/lib/animate.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/web/css/lib/jquery.fancybox.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/web/css/lib/swiper.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/web/css/lib/toastr.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/web/css/style.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/web/css/media.css') }}" />

         @if (app()->getLocale() == 'en')
             <link rel="stylesheet" href="{{ asset('assets/web/css/style-en.css') }}" />
         @endif


    @yield('css')

</head>

<body class="fs_md_theme" id="changeTheme">
    <!--<button class=" butn primary_butn fw-bold " type="button" data-bs-toggle="modal" data-bs-target="#confirmModal"> تأكيد </button>-->

{{--    <!-- Success Modal -->--}}
{{--    <div class="modal stateModal fade" id="confirmModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">--}}
{{--        <div class="modal-dialog modal-dialog-centered modal-lg">--}}
{{--            <div class="modal-content">--}}
{{--                <button type="button" class="butn_close" data-bs-dismiss="modal" aria-label="Close">--}}
{{--                    <i class="fa-solid fa-xmark"></i>--}}
{{--                </button>--}}
{{--                <div class="modal-body">--}}
{{--                    <img src="{{ asset('assets/web/images/modals/confirm.png') }}" alt="" class="img"/>--}}
{{--                    <h3 class="title color-primary  text-center"><b>  تم إرسال الكود بنجاح     </b></h3>--}}

{{--                </div>--}}
{{--            </div>--}}
{{--        </div>--}}
{{--    </div>--}}
{{--    --}}
    <!-- Failure Modal -->
    <div class="modal stateModal fade" id="cancelModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <button type="button" class="butn_close" data-bs-dismiss="modal" aria-label="Close">
                    <i class="fa-solid fa-xmark"></i>
                </button>
                <div class="modal-body">
                    <img src="{{ asset('assets/web/images/modals/cancel.png') }}" alt="" class="img"/>
                    <h3 class="title color-primary  text-center"><b>  تم الغاء العملية   </b></h3>

                </div>
            </div>
        </div>
    </div>

    <!-- loading -->
    <div id="preloader">
        <div id="loading-wrapper" class="show">
            <div id="loading-text"> <img src="{{ asset('assets/web/images/icon.png') }}" alt=""> </div>
            <div id="loading-content"></div>
        </div>
    </div>

@yield('container_content')
<script src="{{ asset('assets/web/js/lib/jquery4.js') }} "></script>
<script src="{{ asset('assets/web/js/lib/popper.js') }} "></script>
<script src="{{ asset('assets/web/js/lib/bootstrap.bundle.min.js') }} "></script>
<script src="{{ asset('assets/web/js/lib/jquery.fancybox.js') }} "></script>
<script src="{{ asset('assets/web/js/lib/swiper.js') }} "></script>
<script src="{{ asset('assets/web/js/lib/wow.min.js') }} "></script>
<script src="{{ asset('assets/web/js/lib/back-to-top.js') }} "></script>
<script src="{{ asset('assets/web/js/lib/toastr.min.js') }}"></script>
<script src="{{ asset('assets/web/js/lib/axios.min.js') }}"></script>
<script src="{{ asset('assets/web/js/main.js') }} "></script>


@yield('container_js')
</body>

</html>
