<!-- Start footer -->
<footer class="footer section pb-0 ">
    <div class="container">
        <div class="row justify-content-between ">
            <div class="col-lg-3">
                <div class="content">
                    <img src="{{asset($logo ?? 'assets/web/images/logo.svg')}}" alt="" class="logo"/>
                    <p class="p">{{stripText(pages(7)->description)}}</p>
                </div>
            </div>
            <div class="col-lg-2">
                <div class="content">
                    <h5 class="title color-primary mb-4">{{__('main.important_links')}}</h5>
                    <div class="links">
                        <a href="{{LaravelLocalization::getLocalizedURL($lang, route('aboutUs'), [], true)}}">{{__('main.about_center')}}</a>
                        <a href="{{LaravelLocalization::getLocalizedURL($lang, route('gallery.index'), [], true)}}">{{__('galleries.photos_videos_galleries')}}</a>
                        <a href="{{LaravelLocalization::getLocalizedURL($lang, route('branch.index'), [], true)}}">{{__('branches.head')}}</a>
                        <a href="{{LaravelLocalization::getLocalizedURL($lang, route('contact.index'), [], true)}}">{{__('main.contact_us')}}</a>
                        <a href="{{LaravelLocalization::getLocalizedURL($lang, route('pages', 'terms-condition'), [], true)}}">{{pages([5])->title}} </a>
                        <a href="{{LaravelLocalization::getLocalizedURL($lang, route('pages', 'evacuation-responsibilaty'), [], true)}}">{{pages([6])->title}}</a>
                    </div>
                </div>
            </div>
            <div class="col-lg-3">
                <div class="content">
                    <h5 class="title color-primary mb-4">{{__('main.center_services')}}</h5>
                    <div class="links">
                        @if(count(services()))
                            @foreach(services() as $service)
                                <a href="{{LaravelLocalization::getLocalizedURL($lang, route('service.show', $service->id), [], true)}}">{{$service->name}}</a>
                            @endforeach
                        @endif
                    </div>
                </div>
            </div>
            <div class="col-lg-3">
                <div class="content">
                    <h5 class="title color-primary mb-4">{{__('main.newsletter_subscription')}}</h5>
                    <p class="p">{{__('main.newsletter_subscription_hint')}}</p>
                    <form method="post" action="{{route('newsletter')}}" class="newsletter_form">
                        <div class="form-group">
                            <input type="text" name="email" class="form-control newsletter_email" placeholder="{{__('newsletters.email')}}">
                            <button class="butn primary_butn newsletter_button">{{__('main.subscribe')}}</button>
                        </div>
                    </form>
                    <div class="down_links d-flex mt-4">
                        <a target="_blank" href="{{$settings['apple_store_link']}}">
                            <img src="{{asset('assets/web/images/icons/apple_store.svg')}}" alt="" class="down_img"/>
                        </a>
                        <a target="_blank" href="{{$settings['google_play_link']}}">
                            <img src="{{asset('assets/web/images/icons/play_store.svg')}}" alt="" class="down_img"/>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="foot py-3 mt-4">
        <div class="container">
            <p class="copyright_p text-white text-center mb-0  ">
{{--                ©  COPYRIGHTS.ALL RESEVED Foot Print 2022--}}
                {!! __('main.copy_right') !!}
            </p>
        </div>
    </div>
</footer>
<!--Scroll to top button-->
<div class="progress-wrap ">
    <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102"><path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" style="transition: stroke-dashoffset 10ms linear 0s; stroke-dasharray: 307.919, 307.919; stroke-dashoffset: 220.587;"></path></svg>
</div>
