@extends('web.layouts.container')

@section('content')
    <section class="about-sec section bg-light">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <img src="{{asset($pages[0]['images']['home_page_image'])}}" alt="" class="sec-img wow fadeInRight"/>
                </div>
                <div class="col-lg-6">
                    <div class="text-box about_desc_container wow fadeInUp">
                        <h4 class="sec_title color-secondary mb-4">{{__('main.about_center')}}</h4>
                        <h1 class="title mb-5">
                            <span class="color-primary">{{$aboutPageTitle1}}</span>{{$aboutPageTitle2}}
                        </h1>
                        {!! $pages[0]['description'] !!}
                    </div>
                    <a href="{{route('aboutUs')}}" class="butn secondary_butn mt-4 px-5">{{__('main.read_more')}}</a>
                    <div class="down_links d-flex mt-5">
                        <a target="_blank" href="{{$settings['apple_store_link']}}">
                            <img src="{{asset('assets/web/images/icons/apple_store.svg')}}" alt="" class="down_img"/>
                        </a>
                        <a target="_blank" href="{{$settings['google_play_link']}}">
                            <img src="{{asset('assets/web/images/icons/play_store.svg')}}" alt="" class="down_img"/>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <img src="{{asset('assets/web/images/pattern-1.svg')}}" alt="" class="pattern"/>
    </section>
    <!-- Start services-sec -->
    <section id="services-sec" class="services-sec section">
        <div class="container">
            <h1 class="sec_title mb-5 wow fadeInDown">{{__('main.our_medial_services')}}</h1>
            <div class="swiper-container services_swiper pb-5 wow fadeInUp">
                <div class="swiper-wrapper">
                    @if(count($services))
                        @foreach($services as $service)
                        <div class="swiper-slide">
                            <div class="serv_card">
                                <a href="{{route('service.show', $service->id)}}">
                                    <img src="{{asset($service->image)}}" alt="" class="sec-img serv_img"/>
                                </a>
                                <div class="card-body">
                                    <?php
                                    /** @var TYPE_NAME $service */
                                    $namePart1 = wordLimit($service->name, 2, '');
                                    $namePart2 = str_replace($namePart1, '', $service->name);
                                    ?>
                                    <a href="{{route('service.show', $service->id)}}" class="title fs-5 fw-bold ">
                                        {{$namePart1}} <br>
                                        {{$namePart2}}
                                    </a>
                                    <p class="p">{{stripText(wordLimit($service->main_section['desc_'.$lang], 33))}}</p>
                                    <a href="{{route('booking.bookingForm', $service->id)}}" class="butn primary_butn m-auto">{{__('main.book_appointment')}}</a>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    @endif
                </div>
                <div class="swiper-pagination"></div>
            </div>
        </div>
    </section>
    <!-- Start doctors-sec -->
    <section class="doctors-sec section bg-light">
        <div class="container">
            <h1 class="sec_title mb-5 wow fadeInDown">   {{__('main.our_doctors')}}  </h1>
            <div class="swiper-container dr_swiper pb-5 wow fadeInUp">
                <div class="swiper-wrapper">
                    @if(count($doctors))
                        @foreach($doctors as $doctor)
                            <div class="swiper-slide">
                                <div class="dr_card">
                                    <img src="{{asset($doctor->image)}}" alt="" class="sec-img"/>
                                    <div class="dr_data">
                                        <h5 class="name color-primary ">{{$doctor->name}}</h5>
                                        <h6 class="job mb-0">{{$doctor->specialist}}</h6>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    @endif
                </div>
                <div class="swiper-pagination"></div>
            </div>
        </div>
    </section>
    <!-- Start feedback-sec -->
    <section class="feedback-sec section">
        <div class="container">
            <h1 class="sec_title text-white mb-5 wow fadeInDown">{{__('main.our_client_reviews')}}</h1>
            <div class="swiper-container feedback_swiper pb-5 wow fadeInUp">
                <div class="swiper-wrapper">
                    @if(count($evaluatesAndReviews))
                        @foreach($evaluatesAndReviews as $evaluatesAndReview)
                            <div class="swiper-slide">
                                <div class="feedback_card">
                                    <h1 class="quote_icon color-secondary mb-3"><i class="fa-solid fa-quote-right"></i></h1>
                                    <p class="p">{{stripText($evaluatesAndReview['review'] ?? $evaluatesAndReview['comment'])}}</p>
                                    <div class="prof_data">
                                        <h5 class="name"><b>{{$evaluatesAndReview['name']}}</b></h5>
                                        <div class="stars">
                                            @for($i = 1; $i <=5; $i++)
                                                <i class="fa-solid fa-star {{$evaluatesAndReview['rate'] >= $i ? 'active' : ''}}"></i>
                                            @endfor
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    @endif
                </div>
                <div class="swiper-pagination"></div>
            </div>
        </div>
    </section>
    <!-- Start gallery-sec -->
    <section class="gallery-sec section bg-light">
        <div class="container">
            <h1 class="sec_title mb-5 wow fadeInDown">  {{__('main.photo_video_gallery')}}  </h1>
            <ul class="nav nav-pills mb-5 wow fadeInUp" id="pills-tab" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active all_galleries gallery_buttons" data-media-type="all" id="pills-tab1-tab" data-bs-toggle="pill" data-bs-target="#pills-tab1" type="button" role="tab" aria-controls="pills-tab1" aria-selected="true">{{__('galleries.all_galleries')}}</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link gallery_buttons" data-media-type="image_type" id="pills-tab2-tab" data-bs-toggle="pill" data-bs-target="#pills-tab2" type="button" role="tab" aria-controls="pills-tab2" aria-selected="false">{{__('galleries.photos')}}</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link gallery_buttons" data-media-type="video_type" id="pills-tab3-tab" data-bs-toggle="pill" data-bs-target="#pills-tab3" type="button" role="tab" aria-controls="pills-tab3" aria-selected="false">{{__('galleries.videos')}}</button>
                </li>
            </ul>
            <div class="gallery_swipper_container wow fadeInUp">
                <div class="swiper-container gallery_swiper pb-5">
                    <div class="swiper-wrapper">
                        @if(count($galleries))
                            @foreach($galleries as $gallery)
                                <div class="swiper-slide">
                                    <div class="row">
                                        @if($gallery[0] ?? null)
                                            <div class="col-lg-4 {{$gallery[0]['type']}}">
                                                <div class="gallery_card vid_card h_lg">
                                                    @if($gallery[0]['type'] == 'image_type')
                                                        <a href="{{asset($gallery[0]['image'])}}" data-fancybox="">
                                                            <img src="{{asset($gallery[0]['image'])}}" alt="" class="sec-img"/>
                                                        </a>
                                                        <div class="content">
                                                            <i class="bi bi-arrows-fullscreen"></i>
                                                            <h5 class="title text-white fw-bold mb-0">{{$gallery[0]['title']}}</h5>
                                                        </div>
                                                    @endif

                                                    @if($gallery[0]['type'] == 'video_type')
                                                        <img src="{{asset($gallery[0]['image'])}}" alt="" class="sec-img"/>
                                                        <a class="button is-play" data-fancybox href="{{asset($gallery[0]['video_url'])}}">
                                                            <div class="button-outer-circle has-scale-animation"></div>
                                                            <div class="button-outer-circle has-scale-animation has-delay-short"></div>
                                                            <div class="button-icon is-play">
                                                                <svg height="100%" width="100%" fill="#fff"><polygon class="triangle" points="5,0 30,15 5,30" viewBox="0 0 30 15"></polygon><path class="path" d="M5,0 L30,15 L5,30z" fill="none" stroke="#fff" stroke-width="1"></path></svg>
                                                            </div>
                                                        </a>
                                                        <h5 class="vid_title text-white fw-bold mb-0 mt-5">{{$gallery[0]['title']}}</h5>
                                                    @endif
                                                </div>
                                            </div>
                                        @endif
                                        <div class="col-lg-8 ">
                                            <div class="row">
                                                @if($gallery[1] ?? null)
                                                    @if($gallery[1]['type'] == 'image_type')
                                                        <div class="col-md-12 col-6 {{$gallery[1]['type']}}">
                                                            <div class="gallery_card h_md">
                                                                <a href="{{asset($gallery[1]['image'])}}" data-fancybox="images">
                                                                    <img src="{{asset($gallery[1]['image'])}}" alt="" class="sec-img"/>
                                                                </a>
                                                               <div class="content">
                                                                    <i class="bi bi-arrows-fullscreen"></i>
                                                                    <h5 class="title text-white fw-bold mb-0">{{$gallery[1]['title']}}</h5>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endif
                                                    @if($gallery[1]['type'] == 'video_type')
                                                        <div class="gallery_card vid_card col-lg-12 col-6 h_md {{$gallery[1]['type']}}">
                                                            <img src="{{asset($gallery[1]['image'])}}" alt="" class="sec-img"/>
                                                            <a class="button is-play" data-fancybox href="{{asset($gallery[1]['video_url'])}}">
                                                                <div class="button-outer-circle has-scale-animation"></div>
                                                                <div class="button-outer-circle has-scale-animation has-delay-short"></div>
                                                                <div class="button-icon is-play">
                                                                    <svg height="100%" width="100%" fill="#fff"><polygon class="triangle" points="5,0 30,15 5,30" viewBox="0 0 30 15"></polygon><path class="path" d="M5,0 L30,15 L5,30z" fill="none" stroke="#fff" stroke-width="1"></path></svg>
                                                                </div>
                                                            </a>
                                                            <h5 class="vid_title text-white fw-bold mb-0 mt-5">{{$gallery[1]['title']}}</h5>
                                                        </div>
                                                    @endif
                                                @endif
                                                @if($gallery[2] ?? null)
                                                    <div class="col-md-6 col-6">
                                                        @if($gallery[2]['type'] == 'image_type')
                                                            <div class="gallery_card h_md {{$gallery[2]['type']}}">
                                                                <a href="{{asset($gallery[2]['image'])}}" data-fancybox="images">
                                                                    <img src="{{asset($gallery[2]['image'])}}" alt="" class="sec-img"/>
                                                                </a>
                                                               <div class="content">
                                                                    <i class="bi bi-arrows-fullscreen"></i>
                                                                    <h5 class="title text-white fw-bold mb-0">{{$gallery[2]['title']}}</h5>
                                                                </div>
                                                            </div>
                                                        @endif
                                                        @if($gallery[2]['type'] == 'video_type')
                                                            <div class="gallery_card vid_card h_md col-6 {{$gallery[2]['type']}}">
                                                                <img src="{{asset($gallery[2]['image'])}}" alt="" class="sec-img"/>
                                                                <a class="button is-play" data-fancybox href="{{$gallery[2]['video_url']}}">
                                                                    <div class="button-outer-circle has-scale-animation"></div>
                                                                    <div class="button-outer-circle has-scale-animation has-delay-short"></div>
                                                                    <div class="button-icon is-play">
                                                                        <svg height="100%" width="100%" fill="#fff"><polygon class="triangle" points="5,0 30,15 5,30" viewBox="0 0 30 15"></polygon><path class="path" d="M5,0 L30,15 L5,30z" fill="none" stroke="#fff" stroke-width="1"></path></svg>
                                                                    </div>
                                                                </a>
                                                                <h5 class="vid_title text-white fw-bold mb-0 mt-5">{{$gallery[2]['title']}}</h5>
                                                            </div>
                                                        @endif
                                                    </div>
                                                @endif
                                                @if($gallery[3] ?? null)
                                                    <div class="col-md-6 col-12">
                                                        @if($gallery[3]['type'] == 'image_type')
                                                            <div class="gallery_card h_md {{$gallery[3]['type']}}">
                                                                <a href="{{asset($gallery[3]['image'])}}" data-fancybox="images">
                                                                    <img src="{{asset($gallery[3]['image'])}}" alt="" class="sec-img"/>
                                                                </a>
                                                               <div class="content">
                                                                    <i class="bi bi-arrows-fullscreen"></i>
                                                                    <h5 class="title text-white fw-bold mb-0">{{$gallery[3]['title']}}</h5>
                                                                </div>
                                                            </div>
                                                        @endif
                                                        @if($gallery[3]['type'] == 'video_type')
                                                            <div class="gallery_card vid_card h_md  {{$gallery[3]['type']}}">
                                                                <img src="{{asset($gallery[3]['image'])}}" alt="" class="sec-img"/>
                                                                <a class="button is-play" data-fancybox href="{{$gallery[3]['video_url']}}">
                                                                    <div class="button-outer-circle has-scale-animation"></div>
                                                                    <div class="button-outer-circle has-scale-animation has-delay-short"></div>
                                                                    <div class="button-icon is-play">
                                                                        <svg height="100%" width="100%" fill="#fff"><polygon class="triangle" points="5,0 30,15 5,30" viewBox="0 0 30 15"></polygon><path class="path" d="M5,0 L30,15 L5,30z" fill="none" stroke="#fff" stroke-width="1"></path></svg>
                                                                    </div>
                                                                </a>
                                                                <h5 class="vid_title text-white fw-bold mb-0 mt-5">{{$gallery[3]['title']}}</h5>
                                                            </div>
                                                        @endif
                                                    </div>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        @endif
                    </div>
                    <div class="swiper-pagination"></div>
                </div>
            </div>

        </div>
    </section>
    <!-- Start contact-sec -->
    <section class="contact-sec section py-0">
        <div class="map_box map_container">
            {!! $settings['site_map'] !!}
            <div class="container">
                <div class="col-lg-5 ms-auto">
                    <div class="contact_box wow fadeInUp">
                        <h2 class="sec_title text-white mb-5"> {{__('visitorMessages.contact_info')}} </h2>
                        <p class="data_item">
                            <img src="{{asset('assets/web/images/icons/contact-1.svg')}}" alt="" class="icon me-2"/>{{$settings['site_address_'.$lang]}}
                        </p>
                        <p class="data_item">
                            <img src="{{asset('assets/web/images/icons/contact-2.svg')}}" alt="" class="icon me-2"/>{{$settings['site_phone']}}
                        </p>
                        <p class="data_item">
                            <img src="{{asset('assets/web/images/icons/contact-3.svg')}}" alt="" class="icon me-2"/>{{$settings['site_email']}}
                        </p>
                        <div class="social_links d-flex mt-5">
                            @if($settings['facebook'] ?? null) <a target="_blank" href="{{$settings['facebook']}}"><i class="fa-brands fa-facebook-f"></i></a> @endif
                            @if($settings['twitter'] ?? null) <a target="_blank" href="{{$settings['twitter']}}"><i class="fa-brands fa-twitter"></i></a> @endif
                            @if($settings['instagram'] ?? null) <a target="_blank" href="{{$settings['instagram']}}"><i class="fa-brands fa-instagram"></i></a> @endif
                            @if($settings['linkedin'] ?? null) <a target="_blank" href="{{$settings['linkedin']}}"><i class="fa-brands fa-linkedin-in"></i></a> @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="contact_inner">
            <div class="container-fluid px-0">
                <div class="row align-items-center">
                    <div class="col-lg-6 px-0">
                        <div class="form_box h-100 wow fadeInRight">
                            <h2 class="sec_title text-white mb-4">{{__('main.contact_us')}}</h2>
                            <form method="post" action="{{route('contact.store')}}" class="contact_us_form">
                                <div class="form-group mb-3">
                                    <input type="text" name="name" class="form-control" placeholder="{{__('visitorMessages.name')}}">
                                </div>
                                <div class="form-group mb-3">
                                    <input style="direction: rtl" type="email" name="email" class="form-control" placeholder="{{__('visitorMessages.email')}}">
                                </div>
                                <div class="form-group mb-3">
                                    <input style="direction: rtl" type="tel" name="phone" class="form-control" placeholder="{{__('visitorMessages.phone')}}">
                                </div>
{{--                                <div class="form-group mb-3">--}}
{{--                                    <input type="text" name="subject" class="form-control" placeholder="{{__('visitorMessages.subject')}}">--}}
{{--                                </div>--}}
                                <div class="form-group mb-3">
                                    <textarea name="message" class="form-control" placeholder="{{__('visitorMessages.message')}}" rows="5"></textarea>
                                </div>
                                <button class="butn w-100 white_border_butn contact_us_button"><b>{{__('main.send')}}</b></button>
                            </form>
                        </div>
                    </div>
                    <div class="col-lg-6 px-0">
                        <div class="hours_box h-100 work_hours_container">
                            <h2 class="sec_title text-white mb-5">{{__('workHours.head')}}</h2>
                            {!! $workHours->home_page_work_time !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('inner_js')
    <script>
        $('.about_desc_container p').addClass('p');
        $('.work_hours_container p').addClass('hours_item text-white mb-4');
        $('.map_container iframe').prop('width', '100%').prop('height', '500');

        let galleriesButtons = $('button.gallery_buttons');
        // galleriesButtons.click(function () {
        //
        //     if($(this).hasClass('all_galleries')){
        //         $('.video_type').removeClass('d-none');
        //         $('.image_type').removeClass('d-none');
        //     }
        //
        //     let thisMediaClass = $(this).data('media-class');
        //     $(thisMediaClass).removeClass('d-none');
        //
        //     if(thisMediaClass === '.image_type'){
        //         $('.video_type').addClass('d-none');
        //     }
        //     if(thisMediaClass === '.video_type'){
        //         $('.image_type').addClass('d-none');
        //     }
        //
        // });


        let getGalleryMediaRoute = "{{route('getGalleryMedia')}}";

        galleriesButtons.click(async function (e) {
            e.preventDefault();

            $(this).prop('disabled', true);

            let data = {type: $(this).data('media-type')},
                url = getGalleryMediaRoute,
                method = 'get';


            const response=await ajax({
                url,
                data,
                dataType: 'html',
                method
            });

            if(response){
                $(this).prop('disabled', false);
                $('.gallery_swipper_container').html(response);
            }

        });




    </script>
@endsection
