@if(count($galleries))
    <div class="gallery_slider owl-carousel" dir="ltr">
        @foreach($galleries as $gallery)
            @if($gallery->type == 'image_type')
                <div class="item">
                    <div class="gallery_card">
                        <a href="{{asset($gallery->image)}}" class="d-block h-100" data-fancybox>
                            <img src="{{asset($gallery->image)}}" alt="" class="sec-img"/>
                        </a>
                    </div>
                </div>
            @endif
            @if($gallery->type == 'video_type')
                <div class="item">
                    <div class="gallery_card">
                        <img src="{{asset($gallery->image)}}" alt="" class="sec-img"/>
                        <a href="{{$gallery->video_url}}" class="vid_icon" data-fancybox>
                            <i class="fa-regular fa-circle-play"></i>
                        </a>
                    </div>
                </div>
            @endif
        @endforeach
    </div>
@else
    <div style="background-color: #cd9b39" class="alert text-center col-lg-12">{{__('galleries.no_data')}}</div>
@endif

<script>
    var owl = $('.gallery_slider').owlCarousel({
        loop: true,
        responsiveClass: true,
        nav: true,
        margin: 15,
        autoplay:true,
        autoplayTimeout:5000,
        autoplayHoverPause:true,
        smartSpeed: 1000,
        center: true,
        navText: ['&#8592;', '&#8594;'],
        responsive: {
            0: {
                items: 1,
            },
            600: {
                items: 5
            },
            1200: {
                items: 5
            }
        }
    });
</script>
