@extends('web.layouts.container')

@section('content')
    <section class="gallery-sec section bg-light">
        <div class="container">
            <ul class="nav justify-content-center nav-pills mb-5" id="pills-tab" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="pills-tab1-tab" data-bs-toggle="pill" data-bs-target="#pills-tab1" type="button" role="tab" aria-controls="pills-tab1" aria-selected="true">
                        <img src="{{asset('assets/web/images/icons/img.svg')}}" alt="" class="icon"/>
                        {{__('galleries.photos')}}
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="pills-tab2-tab" data-bs-toggle="pill" data-bs-target="#pills-tab2" type="button" role="tab" aria-controls="pills-tab2" aria-selected="false">
                        <img src="{{asset('assets/web/images/icons/vid.svg')}}" alt="" class="icon"/>
                        {{__('galleries.videos')}}
                    </button>
                </li>
            </ul>
            <div class="tab-content" id="pills-tabContent">
                <div class="tab-pane fade show active" id="pills-tab1" role="tabpanel" aria-labelledby="pills-tab1-tab">
                    <div class="row">
                        @if(count($photosGalleries))
                            @foreach($photosGalleries as $photosGalley)
                                @if($photosGalley[0] ?? null)
                                <div class="col-lg-4">
                                    <div class="gallery_card h_lg">
                                        <a href="{{asset($photosGalley[0]['image'])}}" data-fancybox="images">
                                            <img src="{{asset($photosGalley[0]['image'])}}" alt="" class="sec-img"/>
                                        </a>
                                        <div class="content">
                                            <i class="bi bi-arrows-fullscreen"></i>
                                            <h5 class="title text-white fw-bold mb-0">{{$photosGalley[0]['title']}}</h5>
                                        </div>
                                    </div>
                                </div>
                                @endif

                                <div class="col-lg-8">
                                    <div class="row">
                                        @if($photosGalley[1] ?? null)
                                            <div class="col-md-12">
                                                <div class="gallery_card h_md">
                                                    <a href="{{asset($photosGalley[1]['image'])}}" data-fancybox="images">
                                                        <img src="{{asset($photosGalley[1]['image'])}}" alt="" class="sec-img"/>
                                                    </a>
                                                    <div class="content">
                                                        <i class="bi bi-arrows-fullscreen"></i>
                                                        <h5 class="title text-white fw-bold mb-0">{{$photosGalley[1]['title']}}</h5>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                        @if($photosGalley[2] ?? null)
                                        <div class="col-md-6">
                                            <div class="gallery_card h_md">
                                                <a href="{{asset($photosGalley[2]['image'])}}" data-fancybox="images">
                                                    <img src="{{asset($photosGalley[2]['image'])}}" alt="" class="sec-img"/>
                                                </a>
                                                <div class="content">
                                                    <i class="bi bi-arrows-fullscreen"></i>
                                                    <h5 class="title text-white fw-bold mb-0">{{$photosGalley[2]['title']}}</h5>
                                                </div>
                                            </div>
                                        </div>
                                        @endif
                                        @if($photosGalley[3] ?? null)
                                        <div class="col-md-6">
                                            <div class="gallery_card h_md">
                                                <a href="{{asset($photosGalley[3]['image'])}}" data-fancybox="images">
                                                    <img src="{{asset($photosGalley[3]['image'])}}" alt="" class="sec-img"/>
                                                </a>
                                                <div class="content">
                                                    <i class="bi bi-arrows-fullscreen"></i>
                                                    <h5 class="title text-white fw-bold mb-0">{{$photosGalley[3]['title']}}</h5>
                                                </div>
                                            </div>
                                        </div>
                                        @endif
                                    </div>
                                </div>
                            @endforeach
                        @endif
                    </div>
                </div>
                <div class="tab-pane fade" id="pills-tab2" role="tabpanel" aria-labelledby="pills-tab2-tab">
                    <div class="row">
                        @if(count($videosGalleries))
                            @foreach($videosGalleries as $videosGallery)
                                @if($videosGallery[0] ?? null)
                                    <div class="col-lg-4">
                                        <div class="gallery_card vid_card h_lg">
                                            <img src="{{asset($videosGallery[0]['image'])}}" alt="" class="sec-img"/>
                                            <a class="button is-play" data-fancybox href="{{$videosGallery[0]['video_url']}}">
                                                <div class="button-outer-circle has-scale-animation"></div>
                                                <div class="button-outer-circle has-scale-animation has-delay-short"></div>
                                                <div class="button-icon is-play">
                                                    <svg height="100%" width="100%" fill="#fff"><polygon class="triangle" points="5,0 30,15 5,30" viewBox="0 0 30 15"></polygon><path class="path" d="M5,0 L30,15 L5,30z" fill="none" stroke="#fff" stroke-width="1"></path></svg>
                                                </div>
                                            </a>
                                            <h5 class="vid_title text-white fw-bold mb-0 mt-5">{{$videosGallery[0]['title']}}</h5>
                                        </div>
                                    </div>
                                @endif

                                <div class="col-lg-8">
                                    <div class="row">
                                        @if($videosGallery[1] ?? null)
                                            <div class="col-md-12">
                                                <div class="gallery_card vid_card h_md">
                                                    <img src="{{asset($videosGallery[1]['image'])}}" alt="" class="sec-img"/>
                                                    <a class="button is-play" data-fancybox href="{{$videosGallery[1]['video_url']}}">
                                                        <div class="button-outer-circle has-scale-animation"></div>
                                                        <div class="button-outer-circle has-scale-animation has-delay-short"></div>
                                                        <div class="button-icon is-play">
                                                            <svg height="100%" width="100%" fill="#fff"><polygon class="triangle" points="5,0 30,15 5,30" viewBox="0 0 30 15"></polygon><path class="path" d="M5,0 L30,15 L5,30z" fill="none" stroke="#fff" stroke-width="1"></path></svg>
                                                        </div>
                                                    </a>
                                                    <h5 class="vid_title text-white fw-bold mb-0 mt-5">{{$videosGallery[1]['title']}}</h5>

                                                </div>
                                            </div>
                                        @endif
                                            @if($videosGallery[2] ?? null)
                                                <div class="col-md-6">
                                                    <div class="gallery_card vid_card h_md">
                                                        <img src="{{asset($videosGallery[2]['image'])}}" alt="" class="sec-img"/>
                                                        <a class="button is-play" data-fancybox href="{{$videosGallery[2]['video_url']}}">
                                                            <div class="button-outer-circle has-scale-animation"></div>
                                                            <div class="button-outer-circle has-scale-animation has-delay-short"></div>
                                                            <div class="button-icon is-play">
                                                                <svg height="100%" width="100%" fill="#fff"><polygon class="triangle" points="5,0 30,15 5,30" viewBox="0 0 30 15"></polygon><path class="path" d="M5,0 L30,15 L5,30z" fill="none" stroke="#fff" stroke-width="1"></path></svg>
                                                            </div>
                                                        </a>
                                                        <h5 class="vid_title text-white fw-bold mb-0 mt-5">{{$videosGallery[2]['title']}}</h5>
                                                    </div>
                                                </div>
                                            @endif
                                        @if($videosGallery[3] ?? null)
                                            <div class="col-md-6">
                                                <div class="gallery_card vid_card h_md">
                                                    <img src="{{asset($videosGallery[3]['image'])}}" alt="" class="sec-img"/>
                                                    <a class="button is-play" data-fancybox href="{{$videosGallery[3]['video_url']}}">
                                                        <div class="button-outer-circle has-scale-animation"></div>
                                                        <div class="button-outer-circle has-scale-animation has-delay-short"></div>
                                                        <div class="button-icon is-play">
                                                            <svg height="100%" width="100%" fill="#fff"><polygon class="triangle" points="5,0 30,15 5,30" viewBox="0 0 30 15"></polygon><path class="path" d="M5,0 L30,15 L5,30z" fill="none" stroke="#fff" stroke-width="1"></path></svg>
                                                        </div>
                                                    </a>
                                                    <h5 class="vid_title text-white fw-bold mb-0 mt-5">{{$videosGallery[3]['title']}}</h5>
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            @endforeach
                            @endif
                    </div>
                </div>
            </div>

        </div>
    </section>
@endsection

@section('inner_js')
    <script>

    </script>
@endsection
