@extends('web.layouts.container')

@section('content')
    <!-- Start about-sec -->
    <section class="about-sec service-det section bg-light">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-5">
                    <div class="swiper-container serviceDet_swiper">
                        <div class="swiper-wrapper">
                            @if(is_array($service->main_section) && count($service->main_section))
                                @foreach($service->main_section['sliders'] as $mainSectionSlider)
                                    @if($mainSectionSlider['url'])
                                        <div class="swiper-slide">
                                            <div class="img-box">
                                                <img src="{{asset($mainSectionSlider['image'])}}" alt="" class="sec-img"/>
                                                <a class="button is-play" data-fancybox href="{{$mainSectionSlider['url']}}">
                                                    <div class="button-outer-circle has-scale-animation"></div>
                                                    <div class="button-outer-circle has-scale-animation has-delay-short"></div>
                                                    <div class="button-icon is-play">
                                                        <svg height="100%" width="100%" fill="#fff"><polygon class="triangle" points="5,0 30,15 5,30" viewBox="0 0 30 15"></polygon><path class="path" d="M5,0 L30,15 L5,30z" fill="none" stroke="#fff" stroke-width="1"></path></svg>
                                                    </div>
                                                </a>
                                            </div>
                                        </div>
                                    @else
                                        <div class="swiper-slide">
                                            <div class="img-box">
                                                <a href="{{asset($mainSectionSlider['image'])}}" data-fancybox="image">
                                                    <img src="{{asset($mainSectionSlider['image'])}}" alt="" class="sec-img"/>
                                                </a>
                                            </div>
                                        </div>
                                    @endif

                                @endforeach
                            @endif

                        </div>
                        <div class="swiper-pagination"></div>
                    </div>
                </div>
                <div class="col-lg-7">
                    <div class="text-box services_desc_container">
                        <h1 class="title mb-4">
                            <span class="color-primary">   {{$title1}} </span> {{$title2}}
                        </h1>
                        {!! $service->main_section['desc_'.$lang] !!}
                        <a href="#" class="butn primary_butn mt-4 px-5"><b> {{__('services.book_now')}} </b></a>
                    </div>

                </div>
            </div>
        </div>
    </section>
    <!-- Start services-sec -->
    <section class="services-sec service-det-cards section py-5">
        <div class="container">
            <div class="row">
                @if(is_array($service->sub_sections) && count($service->sub_sections))
                    @foreach($service->sub_sections as $subSection)
                        <div class="col-lg-6">
                            <div class="serv_card">
                                <img src="{{asset($subSection['image'])}}" alt="" class="sec-img serv_img"/>

                                <div class="card-body text-start">
                                    <h2 class="title fw-bold ">{{$subSection['title_'.$lang]}}</h2>
                                    <p class="p">{{$subSection['desc_'.$lang]}}</p>
                                </div>
                            </div>
                        </div>
                    @endforeach
                @endif
            </div>
        </div>
    </section>
@endsection

@section('inner_js')
    <script>
        $('.services_desc_container p').addClass('p');
    </script>
@endsection
