@extends('web.layouts.container')

@section('content')
    <section class="about-sec about-pg section bg-light">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-5">
                    <img src="{{asset($aboutPage['images']['about_image'])}}" alt="" class="sec-img"/>
                </div>
                <div class="col-lg-7">
                    <div class="text-box about_desc_container">
                        <h4 class="sec_title color-secondary mb-4">{{$title}}</h4>
                        <h1 class="title mb-5">
                            <span class="color-primary">{{$aboutPageTitle1}}</span>{{$aboutPageTitle2}}
                        </h1>
                        {!! $aboutPage['description'] !!}

                        <div class="row mt-5">
                            @if(count($aboutPagePoints))
                                @foreach($aboutPagePoints['title_'.$lang] as $key => $aboutPagePointTitle)
                                    <div class="col-md-6">
                                        <div class="about_item d-flex align-items-center">
                                            <img src="{{asset($aboutPagePoints['images'][$key])}}" alt="" class="icon"/>
                                            <div class="txt">
                                                <h5 class="label fw-bold mb-2">{{$aboutPagePointTitle}}</h5>
                                                <p class="det mb-0">{{stripText($aboutPagePoints['desc_'.$lang][$key])}}</p>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            @endif
                        </div>
                    </div>

                </div>
            </div>
            <div class="about_cards">
                <div class="swiper-container aboutCards_swiper zi-5">
                    <div class="swiper-wrapper pb-5">
                        <div class="swiper-slide">
                            <div class="about_card">
                                <img src="{{asset($messagePage['image'])}}" alt="" class="icon"/>
                                <h5 class="title fw-bold">{{$messagePage['title']}}</h5>
                                <p class="p">{{stripText($messagePage['description'])}} </p>
                            </div>
                        </div>
                        <div class="swiper-slide">
                            <div class="about_card">
                                <img src="{{asset($goalPage['image'])}}" alt="" class="icon"/>
                                <h5 class="title fw-bold">{{$goalPage['title']}}</h5>
                                <p class="p">{{stripText($goalPage['description'])}} </p>
                            </div>
                        </div>
                        <div class="swiper-slide">
                            <div class="about_card">
                                <img src="{{asset($visionPage['image'])}}" alt="" class="icon"/>
                                <h5 class="title fw-bold">{{$visionPage['title']}}</h5>
                                <p class="p">{{stripText($visionPage['description'])}} </p>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-pagination"></div>
                </div>
                <img src="{{asset('assets/web/images/vector-2.svg')}}" alt="" class="vector_bl"/>
                <img src="{{asset('assets/web/images/vector-1.svg')}}" alt="" class="vector_tr"/>

            </div>
        </div>
    </section>
@endsection

@section('inner_js')
    <script>

        $('.about_desc_container p').addClass('p');
    </script>
@endsection
