@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{ $head ?? ''}}</h3>
</div>

<div class="border-item">
    <form class="form-row add_form" method="post" action="{{ $action }}" enctype="multipart/form-data">
        <input type="hidden" name="user_id" value="{{auth()->id()}}">
        @if($siteSlider ?? ''  && $siteSlider->id)
            @method('PUT')
        @endif
        @csrf

        <div class="form-group col-lg-12">
            <label>{{ meta('button_url', $lang) ?? __('siteSliders.button_url') }} </label>
            <input type="url" class="form-control {{ $errors->has('button_url') ? 'is-invalid' : '' }}" name="button_url" placeholder="{{ meta('button_url', $lang) ?? __('siteSliders.button_url') }}" value='{{ old("button_url", $siteSlider->button_url ?? "") }}'/>
        </div>

        @foreach(languages() as $language)
        <div class="form-group col-lg-12">
            <label>{{ meta('title', $language->local) ?? __('siteSliders.title') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <input type="text" class="form-control {{ $errors->has('title_'.$language->local) ? 'is-invalid' : '' }}" name="title_{{ $language->local }}" placeholder="{{ meta('title', $language->local) ?? __('siteSliders.title') }}" value='{{ old("title_{$language->local}", $siteSlider[$language->local]->title ?? "") }}'/>
        </div>
        <div class="form-group col-lg-12">
            <label>{{ meta('button_title', $language->local) ?? __('siteSliders.button_title') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <input type="text" class="form-control {{ $errors->has('button_title_'.$language->local) ? 'is-invalid' : '' }}" name="button_title_{{ $language->local }}" placeholder="{{ meta('button_title', $language->local) ?? __('siteSliders.button_title') }}" value='{{ old("button_title_{$language->local}", $siteSlider[$language->local]->button_title ?? "") }}'/>
        </div>
        <div class="form-group col-lg-12">
            <label>{{ meta('description', $language->local) ?? __('siteSliders.description')}} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <textarea rows="5" name="description_{{ $language->local }}" class="form-control {{ $errors->has('description_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('description', $language->local) ?? __('siteSliders.description')}}">{{ old("description_{$language->local}", $siteSlider[$language->local]->description ?? "") }}</textarea>
        </div>
        @endforeach

        {{--Start image container--}}
        <div class="form-group col-lg-12">
            <label>{{ meta('image', getCurrentLocale()) ?? __('siteSliders.image') }} </label>
            <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="{{old("image", $siteSlider->image ?? "")}}"/>

            <div class="photos main_photo {{ old('image', $siteSlider->image ?? '') ? ' wow fadeInUp' : 'hide' }}">
                <div class="col-lg-4">
                    <div class="items">
                        <div class="img">
                            <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                <img src="{{asset(old('image', $siteSlider->image ?? ''))}} "  id="image_holder" class="image_holder"/>
                            </a>
                        </div>
                        <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                    </div>
                </div>
            </div>

            <div class="clearfix"></div>
            <span class="input-group-btn pick_button {{ old('image', $siteSlider->image ?? '') ? 'hide' : '' }} ">
                <a id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> Choose
                </a>
            </span>
        </div>
        {{--End image container--}}

        <div class="text-center mt-5 col-12">
            <button class="butn add_button"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>

@endsection

@section('inner_js')
    <!-- Editor JS files -->
    <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>
    {{--        <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>--}}
    <script>
        let route_prefix = "{{ url(config('lfm.prefix')) }}",
            url = "{{url('/')}}/",
            currentLanguage = "{{$lang}}",
            imagePath = "{{asset('')}}",
            inputName = null;
        let imgSrc = "{{asset('assets/admin/images/file-icon.png')}}";
    </script>

    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>

    <script>
        sendAjax('.add_button', '.add_form')
    </script>

@endsection




