<div class="border-item">
    <form class="form-row module_settings_form" method="post" action="{{ $modulesAction }}">
        @if ($modules)
            <input type="hidden" name="update" value="true">
        @endif
        @csrf

        <ul class="nav nav-tabs" id="myTab" role="tablist">
                @foreach ($modules as $module)
                <li class="nav-item module_nav_item mr-3 mb-4 shadow w-25" >
                    <a class="nav-link module_nav_link {{$loop->first ? 'active' : ''}}" id="module-tab-{{$module->id}}" data-toggle="tab" href="#module-{{$module->id}}" role="tab" aria-controls="module-{{$module->id}}" aria-selected="true">
                        <b>{{moduleName($module->path, getCurrentLocale())}}</b>
                    </a>
                </li>
                @endforeach
            </ul>

        <div class="tab-content col-lg-12 mt-3" id="myTabContent">
            @foreach ($modules as $key => $module)
                <div class="tab-pane module_tap_pane {{$loop->first ? 'active' : ''}}" id="module-{{$module->id}}" role="tabpanel" aria-labelledby="module-{{$module->id}}-tab">
                    <ul class="nav nav-tabs" role="tablist">
                        @foreach (languages() as $language)
                            <li class="nav-item lang_nav_item">
                                <a class="nav-link language_link {{$loop->first ? 'active' : ''}}module-tab-{{$module->id}} {{$loop->first ? 'active' : ''}}" id="language_link_{{$language->local}}_{{$module->id}}" data-toggle="tab" href="#language_tab_{{$language->local}}_{{$module->id}}" role="tab" aria-controls="language-tab-{{$language->local}}_{{$module->id}}" aria-selected="true">
                                    <b>{{__('settings.head')}} : {{$language->name}}</b>
                                </a>
                            </li>
                        @endforeach
                    </ul>

                    <div class="tab-content language_tab_content mt-4">
                        @foreach (languages() as $language)
                        <div class="tab-pane {{$loop->first ? 'active' : ''}}" id="language_tab_{{$language->local}}_{{$module->id}}" role="tabpanel" aria-labelledby="language-tab-{{$language->local}}_{{$module->id}}">
                            <div class="form-group d-flex justify-content-start">
                                <label style="width: 20%" class="d-flex align-items-center text-uppercase">module name</label>
                                <input type="text" name="module_name[{{$module->path}}][module_name][{{$language->local}}]" class="form-control" value="{{moduleName($module->path, $language->local)}}">
                            </div>

                            @foreach (metaFields($module->path)[$language->local] as $label => $moduleName)
                                <div class="form-group d-flex justify-content-start">
                                    <label style="width: 20%" class="d-flex align-items-center">{{str_replace('_', ' ', strtoupper($label))}}</label>
                                    <input type="text" name="fields[{{$module->path}}][fields][{{$language->local}}][{{$label}}]" class="form-control" value="{{$moduleName}}">
                                </div>
                            @endforeach
                        </div>
                        @endforeach
                    </div>
                </div>
            @endforeach
        </div>
        <div class="text-center mt-5 col-12">
            <button class="butn module_settings_button"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>
