@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{$head ?? '' }}</h3>
</div>

<div class="border-item">
    <form class="form-row add_form" method="post" action="{{ $action }}" enctype="multipart/form-data">
        @if($service ?? ''  && $service->id)
            @method('PUT')
        @endif
        @csrf

            <div class="form-group col-lg-12">
                <label>{{ meta('durations', $lang) ?? __('services.durations') }} </label>
                <input type="number" min="1" class="form-control {{ $errors->has('durations') ? 'is-invalid' : '' }}" name="durations" placeholder="{{ meta('durations', $lang) ?? __('siteSliders.durations') }}" value='{{ old("durations", $service->durations ?? 0) }}'/>
            </div>

            @foreach(languages() as $language)
                <div class="form-group col-lg-12">
                    <label>{{ meta('name', $language->local) ?? __('services.name') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                    <input type="text" class="form-control {{ $errors->has('name_'.$language->local) ? 'is-invalid' : '' }}" name="name_{{ $language->local }}" placeholder="{{ meta('name', $language->local) ?? __('services.name') }}" value='{{ old("name_{$language->local}", $service[$language->local]->name ?? "") }}'/>
                </div>

                <div class="form-group col-lg-12">
                    <label>{{ meta('main_section_name', $language->local) ?? __('services.main_section_name') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                    <input type="text" class="form-control {{ $errors->has('main_section_name_'.$language->local) ? 'is-invalid' : '' }}" name="main_section_name_{{ $language->local }}" placeholder="{{ meta('main_section_name', $language->local) ?? __('services.main_section_name') }}" value='{{ old("main_section_name_{$language->local}", $mainSection['title_'.$language->local] ?? "") }}'/>
                </div>
                <div class="form-group col-lg-12">
                    <label>{{ meta('main_section_desc', $language->local) ?? __('services.main_section_desc')}} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                    <textarea rows="5" name="main_section_desc_{{ $language->local }}" class="form-control {{ $errors->has('main_section_desc_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('main_section_desc', $language->local) ?? __('services.main_section_desc')}}">{{ old("main_section_desc_{$language->local}", $mainSection['desc_'.$language->local] ?? "") }}</textarea>
                </div>


                @foreach($subSections as $subSection)
                    <div class="form-group col-lg-12">
                        <label>{{ meta('sub_section_name', $language->local) ?? __('services.sub_section_name') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                        <input type="text" class="form-control {{ $errors->has('sub_section_name_'.$language->local) ? 'is-invalid' : '' }}" name="sub_section_name_{{ $language->local }}" placeholder="{{ meta('sub_section_name', $language->local) ?? __('services.sub_section_name') }}" value='{{ old("sub_section_name_{$language->local}", $subSection['title_'.$language->local] ?? "") }}'/>
                    </div>
                    <div class="form-group col-lg-12">
                        <label>{{ meta('sub_section_desc', $language->local) ?? __('services.sub_section_desc')}} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                        <textarea rows="5" name="sub_section_desc_{{ $language->local }}" class="form-control {{ $errors->has('sub_section_desc_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('sub_section_desc', $language->local) ?? __('services.sub_section_desc')}}">{{ old("sub_section_desc_{$language->local}", $subSection['desc_'.$language->local] ?? "") }}</textarea>
                    </div>
                @endforeach

            @endforeach



            @if( count($branches))
                <div class="form-group col-lg-12">
                    <label>{{ meta('branch_ids', $lang) ??  __('services.branch_ids') }} </label>
                    <div class="clearfix"></div>
                    <div class="row">
                        @foreach($branches as $branch)
                            <div class="col-sm-4">
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox" {{ in_array($branch->id, $branchIds) ? 'checked' : '' }} value="{{ $branch->branch_id }}" class="custom-control-input" id="branch_{{ $loop->iteration }}" name="branch_ids[]">
                                    <label class="custom-control-label" for="branch_{{ $loop->iteration }}"> {{ $branch->name }} </label>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endif


            {{--Start image container--}}
            <div class="form-group col-lg-12 image_container">
                <label>{{ meta('image', $lang) ?? __('services.image') }} </label>
                <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="{{old("image", $service->image ?? "")}}"/>

                <div class="photos main_photo {{ old('image', $service->image ?? '') ? ' wow fadeInUp' : 'hide' }}">
                    <div class="col-md-4">
                        <div class="items">
                            <div class="img">
                                <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                    <img src="{{asset(old('image', $service->image ?? ''))}} "  id="image_holder" class="image_holder"/>
                                </a>
                            </div>
                            <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                        </div>
                    </div>
                </div>

                <div class="clearfix"></div>
                <span class="input-group-btn pick_button {{ old('image', $service->image ?? '') ? 'hide' : '' }} ">
                <a id="lfm"  data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> {{__('dashboard.choose')}}
                </a>
             </span>
            </div>
            {{--End image container--}}


        <div class="text-center mt-5 col-12">
            <button class="butn add_button"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>

@endsection

@section('inner_js')

    <!-- Editor JS files -->
    <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>
    {{--        <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>--}}
    <script>
        let route_prefix = "{{ url(config('lfm.prefix')) }}",
            url = "{{url('/')}}/",
            currentLanguage = "{{$lang}}",
            imagePath = "{{asset('')}}",
            inputName = null;
    </script>

    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>

    <script>
        sendAjax('.add_button', '.add_form')
    </script>

@endsection



