@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{$head ?? '' }}</h3>
</div>

<div class="border-item">
    <form class="form-row add_form" method="post" action="{{ $action }}" enctype="multipart/form-data">
        @if($service ?? ''  && $service->id)
            @method('PUT')
        @endif
        @csrf

            @foreach(languages() as $language)
                <div class="form-group col-lg-12">
                    <label>{{ meta('name', $language->local) ?? __('services.name') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                    <input type="text" class="form-control {{ $errors->has('name_'.$language->local) ? 'is-invalid' : '' }}" name="name_{{ $language->local }}" placeholder="{{ meta('name', $language->local) ?? __('services.name') }}" value='{{ old("name_{$language->local}", $service[$language->local]->name ?? "") }}'/>
                </div>
                <div class="form-group col-lg-12">
                    <label>{{ meta('description', $language->local) ?? __('services.description')}} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                    <textarea rows="5" name="description_{{ $language->local }}" class="form-control {{ $errors->has('description_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('description', $language->local) ?? __('services.description')}}">{{ old("description_{$language->local}", $service[$language->local]->description ?? "") }}</textarea>
                </div>

            @endforeach

            {{--Start image container--}}
            <div class="form-group col-lg-12 image_container">
                <label>{{ meta('image', $lang) ?? __('services.image') }} </label>
                <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="{{old("image", $service->image ?? "")}}"/>

                <div class="photos main_photo {{ old('image', $service->image ?? '') ? ' wow fadeInUp' : 'hide' }}">
                    <div class="col-md-4">
                        <div class="items">
                            <div class="img">
                                <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                    <img src="{{asset(old('image', $service->image ?? ''))}} "  id="image_holder" class="image_holder"/>
                                </a>
                            </div>
                            <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                        </div>
                    </div>
                </div>

                <div class="clearfix"></div>
                <span class="input-group-btn pick_button {{ old('image', $service->image ?? '') ? 'hide' : '' }} ">
                <a id="lfm"  data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> {{__('dashboard.choose')}}
                </a>
             </span>
            </div>
            {{--End image container--}}


        <div class="text-center mt-5 col-12">
            <button class="butn add_button"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>

@endsection

@section('inner_js')

    <!-- Editor JS files -->
    <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>
    {{--        <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>--}}
    <script>
        let route_prefix = "{{ url(config('lfm.prefix')) }}",
            url = "{{url('/')}}/",
            currentLanguage = "{{$lang}}",
            imagePath = "{{asset('')}}",
            inputName = null;
    </script>

    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>

    <script>

        let choose = "{{__('dashboard.choose')}}",
            addSliderTitle = "{{ __('services.add_slider') }}",
            sliderImage = "{{__('services.main_section_image')}}",
            videoUrl = "{{__('services.main_section_video_url')}}",
            subSectionName = "{{__('services.sub_section_name')}}",
            subSectionDesc = "{{__('services.sub_section_desc')}}",
            subSectionImage = "{{__('services.sub_section_image')}}";

        sendAjax('.add_button', '.add_form');

        $('.add_slide').click(function (e) {
            e.preventDefault();
            let counter = (Math.random()*100000).toString(20).replace('.', '_');
            let htmlContent = `
                <div class="form-group col-lg-12 card deleted_slider slider_card">
                       <div class="row">
                       <div class="form-group col-md-12 d-flex justify-content-end">
                       <a href="#" class="delete_slider mt-3"><i class="fa fa-trash-alt text-danger fa-2x"></i></a>
                       </div>
                        <div class="form-group col-md-12">
                            <input type="text" name="main_section_video_url[]"  placeholder="${videoUrl}" class="form-control" value=""/>
                        </div>

                         <div class="form-group col-lg-12">
                                <label>${sliderImage}</label>
                                <input id="image_thumbnail_${counter}" class="image_thumbnail_${counter}" type="hidden" name="main_section_image[]" value=""/>

                                <div class="photos main_photo_${counter} hide">
                                    <div class="col-lg-4">
                                        <div class="items">
                                            <div class="img">
                                                <a href="#" id="lfm" data-input=".image_thumbnail_${counter}" data-preview=".image_holder_${counter}" class="lfm" data-hide=".pick_button_${counter}">
                                                    <img src="" id="image_holder_${counter}" class="image_holder_${counter}"/>
                                                </a>
                                            </div>
                                            <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail_${counter}" data-hide=".main_photo_${counter}" data-show=".pick_button_${counter}"><i class="fas fa-times"></i></a>
                                        </div>
                                    </div>
                                </div>

                                <div class="clearfix"></div>
                                <span class="input-group-btn pick_button_${counter}">
                                <a id="lfm" data-input=".image_thumbnail_${counter}" data-preview=".image_holder_${counter}" data-show=".main_photo_${counter}" data-hide=".pick_button_${counter}" class="lfm btn btn-primary text-light">
                                    <i class="fas fa-camera-retro"></i> ${choose}
                                </a>
                             </span>
                            </div>
                       </div>
                    </div>`;

            $('.sliders_container').append(htmlContent);

        });

        $(document).on('click', '.delete_slider', function (e) {
            e.preventDefault();
            $(this).parents('.deleted_slider').remove();
        });

        /**
         * Add sub section block
         */

        $('.add_sub_section').click(function (e) {
            e.preventDefault();
            let counter = (Math.random()*100000).toString(20).replace('.', '_');
            console.log(counter)
            let htmlContent = `
                <div class="card mb-3 sub_section_item">
                    <div class="form-group col-md-12 d-flex justify-content-end">
                        <a href="#" class="delete_sub_section_item mt-3"><i class="fa fa-trash-alt text-danger fa-2x"></i></a>
                    </div>
                    <div class="card-body row">
                        <div class="form-group col-lg-12">
                            <label>${subSectionName} (Arabic) </label>
                            <input type="text" class="form-control" name="sub_section_name_ar[]" placeholder="${subSectionName}" value=''/>
                        </div>
                        <div class="form-group col-lg-12">
                            <label>${subSectionDesc} (Arabic) </label>
                            <textarea rows="5" class="form-control" name="sub_section_desc_ar[]" placeholder="${subSectionDesc}"></textarea>
                        </div>
                        <div class="form-group col-lg-12">
                            <label>${subSectionName} (English) </label>
                            <input type="text" class="form-control" name="sub_section_name_en[]" placeholder="${subSectionName}" value=''/>
                        </div>
                        <div class="form-group col-lg-12">
                            <label>${subSectionDesc} (English) </label>
                            <textarea rows="5" class="form-control" name="sub_section_desc_en[]" placeholder="${subSectionDesc}"></textarea>
                        </div>
                        <div class="form-group col-lg-12">
                                <label>${subSectionImage}</label>
                                <input id="image_thumbnail_${counter}" class="image_thumbnail_${counter}" type="hidden" name="sub_section_image[]" value=""/>
                                <div class="photos main_photo_${counter} hide">
                                    <div class="col-lg-4">
                                        <div class="items">
                                            <div class="img">
                                                <a href="#" id="lfm" data-input=".image_thumbnail_${counter}" data-preview=".image_holder_${counter}" class="lfm" data-hide=".pick_button_${counter}">
                                                    <img src="" id="image_holder_${counter}" class="image_holder_${counter}"/>
                                                </a>
                                            </div>
                                            <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail_${counter}" data-hide=".main_photo_${counter}" data-show=".pick_button_${counter}"><i class="fas fa-times"></i></a>
                                        </div>
                                    </div>
                                </div>

                                <div class="clearfix"></div>
                                <span class="input-group-btn pick_button_${counter}">
                                <a id="lfm" data-input=".image_thumbnail_${counter}" data-preview=".image_holder_${counter}" data-show=".main_photo_${counter}" data-hide=".pick_button_${counter}" class="lfm btn btn-primary text-light">
                                    <i class="fas fa-camera-retro"></i> ${choose}
                                </a>
                             </span>
                            </div>
                    </div>
                </div>`;
            $('.sub_sections_container').append(htmlContent);

        });

        $(document).on('click', '.delete_sub_section_item', function (e) {
            e.preventDefault();
            $(this).parents('.sub_section_item').remove();
        });

        $('body').on('DOMNodeInserted', '.sliders_container, .sub_sections_container', function(e) {
            if ($(e.target).find('.lfm')) {
                $('.lfm').filemanager('image', {prefix: route_prefix});
            }
        });


    </script>

@endsection



