@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{$head ?? '' }}</h3>
</div>

<div class="border-item">
    <form class="form-row add_form" method="post" action="{{ $action }}" enctype="multipart/form-data">
        @if($page ?? ''  && $page->id)
            @method('PUT')
        @endif
        @CSRF

        @if($page->id == 1)
        <div class="form-group col-lg-12 video_added_type">
            <label>{{ meta('video_added_type', $lang) ?? __('pages.video_added_type') }} </label>
            <select name="video_added_type" class="form-control {{ $errors->has('video_added_type') ? 'is-invalid' : '' }}">
                <option value="">{{__('pages.video_added_type')}}</option>
                <option {{($page->meta['video_url'] ?? null) ? 'selected' : '' }} value="url">{{__('pages.video_url')}}</option>
                <option {{($page->meta['video'] ?? null) ? 'selected' : '' }} value="video">{{__('pages.video')}}</option>
            </select>
        </div>
        <div class="form-group video_url col-lg-12 {{($page->meta['video_url'] ?? null) ? '' : 'd-none'}}">
            <label>{{ meta('video_url', $lang) ?? __('pages.video_url') }} </label>
            <input type="url" class="form-control {{ $errors->has('video_url') ? 'is-invalid' : '' }}" name="video_url" placeholder="{{ meta('video_url', $lang) ?? __('pages.video_url') }}" value='{{ old("video_url", $page->meta['video_url'] ?? null) }}'/>
        </div>
        @endif

        @foreach(languages() as $language)
        <div class="form-group col">
            <label>{{ meta('page_title', $language->local) ?? __('pages.page_title') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <input type="text" class="form-control {{ $errors->has('page_title_'.$language->local) ? 'is-invalid' : '' }}" name="page_title_{{ $language->local }}" placeholder="{{ meta('page_title', $language->local) ?? __('pages.page_title') }}" value='{{ old("page_title_{$language->local}", $page[$language->local]->page_title ?? null) }}'/>
        </div>

        @if($page[$language->local]->title ?? null)
            <div class="form-group col">
                <label>{{ meta('title', $language->local) ?? __('pages.title') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                <input type="text" class="form-control {{ $errors->has('title_'.$language->local) ? 'is-invalid' : '' }}" name="title_{{ $language->local }}" placeholder="{{ meta('title', $language->local) ?? __('pages.title') }}" value='{{ old("title_{$language->local}", $page[$language->local]->title ?? null) }}'/>
            </div>
        @endif
        @if($page[$language->local]->description)
            <div class="form-group col-lg-12">
                <label>{{ meta('description', $language->local) ?? __('pages.description') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                <textarea id="description_{{ $language->local }}" name="description_{{ $language->local }}" class="form-control my-editor {{ $errors->has('description_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('description', $language->local) ?? __('pages.description') }}">{{ old("description_{$language->local}", $page[$language->local]->description ?? null) }}</textarea>
            </div>
        @endif
        @endforeach

        @if($page->id == 8)
            @foreach(languages() as $language)
            <div class="form-group col-lg-3">
                <label>{{ meta('users', $language->local) ?? __('pages.users') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                <input type="text" class="form-control {{ $errors->has('title_'.$language->local) ? 'is-invalid' : '' }}" name="users_{{ $language->local }}" placeholder="{{ meta('users', $language->local) ?? __('pages.users') }}" value='{{ old("users_{$language->local}", $page->meta['users'][$language->local] ?? null) }}'/>
            </div>
            <div class="form-group col-lg-3">
                <label>{{ meta('services', $language->local) ?? __('pages.services') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                <input type="text" class="form-control {{ $errors->has('title_'.$language->local) ? 'is-invalid' : '' }}" name="services_{{ $language->local }}" placeholder="{{ meta('services', $language->local) ?? __('pages.services') }}" value='{{ old("services_{$language->local}", $page->meta['services'][$language->local] ?? null) }}'/>
            </div>
            <div class="form-group col-lg-3">
                <label>{{ meta('employees', $language->local) ?? __('pages.employees') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                <input type="text" class="form-control {{ $errors->has('title_'.$language->local) ? 'is-invalid' : '' }}" name="employees_{{ $language->local }}" placeholder="{{ meta('employees', $language->local) ?? __('pages.employees') }}" value='{{ old("employees_{$language->local}", $page->meta['employees'][$language->local] ?? null) }}'/>
            </div>
            <div class="form-group col-lg-3">
                <label>{{ meta('projects', $language->local) ?? __('pages.projects') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                <input type="text" class="form-control {{ $errors->has('title_'.$language->local) ? 'is-invalid' : '' }}" name="projects_{{ $language->local }}" placeholder="{{ meta('projects', $language->local) ?? __('pages.projects') }}" value='{{ old("projects_{$language->local}", $page->meta['projects'][$language->local] ?? null) }}'/>
            </div>
            @endforeach

                <div class="form-group col-lg-3">
                    <label>{{ meta('statistics', $lang) ?? __('pages.statistics') }} </label>
                    <input type="text" class="form-control {{ $errors->has('statistics') ? 'is-invalid' : '' }}" name="statistics[]" placeholder="{{ meta('statistics', $lang) ?? __('pages.statistics') }}" value='{{ old("statistics", $page->meta['users']['statistics'] ?? null) }}'/>
                </div>
                <div class="form-group col-lg-3">
                    <label>{{ meta('statistics', $lang) ?? __('pages.statistics') }} </label>
                    <input type="text" class="form-control {{ $errors->has('statistics') ? 'is-invalid' : '' }}" name="statistics[]" placeholder="{{ meta('statistics', $lang) ?? __('pages.statistics') }}" value='{{ old("statistics", $page->meta['services']['statistics'] ?? null) }}'/>
                </div>
                <div class="form-group col-lg-3">
                    <label>{{ meta('statistics', $lang) ?? __('pages.statistics') }} </label>
                    <input type="text" class="form-control {{ $errors->has('statistics') ? 'is-invalid' : '' }}" name="statistics[]" placeholder="{{ meta('statistics', $lang) ?? __('pages.statistics') }}" value='{{ old("statistics", $page->meta['employees']['statistics'] ?? null) }}'/>
                </div>
                <div class="form-group col-lg-3">
                    <label>{{ meta('statistics', $lang) ?? __('pages.statistics') }} </label>
                    <input type="text" class="form-control {{ $errors->has('statistics') ? 'is-invalid' : '' }}" name="statistics[]" placeholder="{{ meta('statistics', $lang) ?? __('pages.statistics') }}" value='{{ old("statistics", $page->meta['projects']['statistics'] ?? null) }}'/>
                </div>

                <div class="form-group col-lg-12">
                    <label>{{ meta('banner_url', $lang) ?? __('pages.banner_url') }} </label>
                    <input type="url" class="form-control {{ $errors->has('banner_url') ? 'is-invalid' : '' }}" name="banner_url" placeholder="{{ meta('banner_url', $lang) ?? __('pages.banner_url') }}" value='{{ old("banner_url", $page->meta['banner_url'] ?? null) }}'/>
                </div>

        @endif





        {{--Start image container--}}
        @if(in_array($page->id, [1,2,3,4,5,6,7,8]))
            <div class="form-group col-lg-6">
                <label>{{ meta('image', $lang) ?? __('pages.image') }} </label>
                <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="{{old("image", $page->image ?? "")}}"/>

                <div class="photos image_main_photo {{ old('image', $page->image ?? '') ? ' wow fadeInUp' : 'hide' }}">
                    <div class="col-lg-12">
                        <div class="items">
                            <div class="img">
                                <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".image_pick_button">
                                    <img src="{{asset(old('image', $page->image ?? ''))}} "  id="image_holder" class="image_holder"/>
                                </a>
                            </div>
                            <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".image_main_photo" data-show=".image_pick_button"><i class="fas fa-times"></i></a>
                        </div>
                    </div>
                </div>

                <div class="clearfix"></div>
                <span class="input-group-btn image_pick_button {{ old('image', $page->image ?? '') ? 'hide' : '' }} ">
            <a id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" data-show=".image_main_photo" data-hide=".image_pick_button" class="lfm btn btn-primary text-light">
                <i class="fas fa-camera-retro"></i> {{__('dashboard.choose')}}
            </a>
        </span>
            </div>

            {{--Start video container--}}
            <div class="form-group col-lg-6 video_container {{($page->meta['video'] ?? null) ? '' : 'd-none'}}">
                <label>{{ meta('video', getCurrentLocale()) ?? __('galleries.video') }} </label>
                <input id="video_thumbnail" class="video_thumbnail" type="hidden" name="video" value="{{old("video", $page->meta['video'] ?? "")}}"/>

                <div class="photos main_video {{ old('video', $page->meta['video'] ?? '') ? ' wow fadeInUp' : 'hide' }}">
                    <div class="col-lg-12">
                        <div class="items">
                            <div class="img">
                                <a href="#" id="lfm" data-input=".video_thumbnail" data-preview=".video_holder" class="lfm" data-hide=".pick_button">
                                    <img src="{{asset('assets/web/images/icons/video.png')}}"  id="video_holder" class="video_holder"/>
                                </a>
                            </div>
                            <a href="#" class="showHide resetImage close" data-empty=".video_thumbnail" data-hide=".main_video" data-show=".video_pick_button"><i class="fas fa-times"></i></a>
                        </div>
                    </div>
                </div>

                <div class="clearfix"></div>
                <span class="input-group-btn video_pick_button {{ old('video', $page->meta['video'] ?? '') ? 'hide' : '' }} ">
                    <a id="lfm" data-input=".video_thumbnail" data-preview=".video_holder" data-show=".main_video" data-hide=".video_pick_button" class="lfm btn btn-primary text-light">
                        <i class="fas fa-camera-retro"></i> {{__('dashboard.choose')}}
                    </a>
                </span>
            </div>
            {{--End video container--}}

        @endif
        {{--End image container--}}

        <div class="text-center mt-5 col-12">
            <button class="butn add_button"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>

@endsection

@section('inner_js')
    <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>
    {{-- <script src="//cdn.tinymce.com/4/tinymce.min.js"></script> --}}
    <script>
        let route_prefix = "{{ url(config('lfm.prefix')) }}",
            url = "{{url('/')}}/",
            currentLanguage = "{{$lang}}",
            imagePath = "{{asset('')}}",
            videoPath = "{{asset('assets/web/images/icons/video.png')}}",
            inputName = null;
        let imgSrc = "{{asset('assets/admin/images/file-icon.png')}}";
    </script>
    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>
    <script src="{{ asset('assets/admin/js/articles.js') }}"></script>


    <script>

        sendAjax('.add_button', '.add_form');

        $('select[name="video_added_type"]').change(function () {

            let thisVal = $(this).val();

            if(thisVal === 'video'){
                $('.video_container').removeClass('d-none');
                $('.video_url').addClass('d-none');
                $('input[name="video_url"]').val(null);
            }

            if(thisVal === 'url'){
                $('.video_url').removeClass('d-none');
                $('.video_container').addClass('d-none');
                $('.video_container a.close').trigger('click');
            }

            if(!thisVal){
                $('.video_container').addClass('d-none');
                $('.video_container a.close').trigger('click');
                $('.video_url').addClass('d-none');
                $('input[name="video_url"]').val(null);
            }

        });

        $('.add_properties').click(function (e) {
            e.preventDefault();
            let counter = (Math.random()*100000).toString(20).replace('.', '_');
            let serviceDiv = `
                <div class="form-group col-lg-12 card deleted_property property_card">
                    <label>{{ __('pages.properties') }}</label>
                   <div class="row">
                   <div class="form-group col-md-12 d-flex justify-content-end">
                   <a href="#" class="btn btn-danger delete_property mr-3"><i class="fa fa-times"></i></a>
                   </div>
                    @foreach($languages as $language)
                        <div class="form-group col-md-12">
                            <input type="text" name="properties_{{$language->local}}[]" placeholder="{{__('pages.property_title') . ' ' . "($language->name)"}}" class="form-control" value=""/>
                        </div>
                    @endforeach

                </div>`;

            $('.property_container').append(serviceDiv);

        });

        $(document).on('click', '.delete_property', function (e) {
            e.preventDefault();
            $(this).parents('.deleted_property').remove();
        });

        $('body').on('DOMNodeInserted', '.properties_container', function(e) {
            if ($(e.target).find('.lfm')) {
                $('.lfm').filemanager('image', {prefix: route_prefix});
            }
        });

    </script>

@endsection



