@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{ $head ?? '' }}</h3>
</div>

<div class="border-item">
    <form class="form-row" method="post" action="{{ $action }}">
        @if($newsletter ?? ''  && $newsletter->id ?? '')
            @method('PUT')
        @endif
        @CSRF

        <div class="form-group col-lg-6">
            <label>{{ meta('email', getCurrentLocale()) ??  __('newsletters.send_to') }} </label>
            @if ($newsletter ?? '')
                <input type="text" name="email" class="form-control bg-light" readonly value="{{$newsletter->email}}">
                @else
                <select name="email" id="email" class="form-control {{ $errors->has('email') ? 'is-invalid' : '' }}">
                    <option value="">{{ meta('email', getCurrentLocale()) ??  __('newsletters.select') }}</option>
                    <option {{old("email") == 'all' ? 'selected': ''}} value="all">{{ meta('all', getCurrentLocale()) ??  __('newsletters.all') }}</option>
                    @foreach (newsletters() as $letter)
                        <option {{old("email", $newsletter->email ?? "") == $letter->email ? 'selected': ''}} value="{{$letter->email}}">{{$letter->email ?? ''}}</option>
                    @endforeach
                </select>
            @endif

        </div>
        <div class="form-group col-lg-6">
            <label>{{ meta('subject', getCurrentLocale()) ??  __('newsletters.subject') }}</label>
            <input type="text" class="form-control {{ $errors->has('subject') ? 'is-invalid' : '' }}" name="subject" placeholder="{{ meta('subject', getCurrentLocale()) ??  __('newsletters.subject') }}" value='{{ old("subject", $newsletter->subject ?? "") }}'/>
        </div>
        <div class="form-group col-lg-12">
            <label>{{ meta('message', getCurrentLocale()) ??  __('newsletters.message') }}</label>
            <textarea name="message" class="form-control my-editor {{ $errors->has('message') ? 'is-invalid' : '' }} my-editor" placeholder="{{ meta('message', getCurrentLocale()) ??  __('newsletters.message') }}">{{ old("message", $newsletter->message ?? "") }}</textarea>
        </div>

        <div class="text-center mt-5 col-12">
            <button class="butn"><span>{{ __('dashboard.send') }}</span></button>
        </div>
    </form>
</div>

@endsection

@section('inner_js')
    <!-- Editor JS files -->
    <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>
{{--        <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>--}}
    <script>
        var route_prefix = "{{ url(config('lfm.prefix')) }}";
        var url = "{{asset('')}}/";
    </script>
    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>
@endsection
