@extends('admin.layouts.container')
@section('css')
    <style>
        .chart_links p{
            margin-right: 5px;
        }
    </style>
@endsection
@section('content')
    <!-- ------------ charts ------------- -->
    <div class="charts_container">
        <div class="row">
            {{-- Year chart--}}
            <div class="col-lg-12">
                <div class="chart_box">
                    <div class="chart_head mb-4">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="d-flex justify-content-start">
                                    <h5> {{__('dashboard.visits_in')}} </h5>
                                </div>
                                <div class="d-flex justify-content-start">
                                    <a data-axis="{{$yearsAxis}}" data-data="{{$yearsData}}" data-color="#27a444" class="btn last_7_years chart_links d-flex align-items-center disabled" href="#0"><i class="fa fa-circle text-success"></i> <p>{{__('dashboard.last_7_years')}} </p></a>
                                    <a data-axis="{{$monthsAxis}}" data-data="{{$monthsData}}" data-color="#3abad6" class="btn last_7_months chart_links d-flex align-items-center" href="#0"><i class="fa fa-circle text-primary"></i> <p>{{__('dashboard.last_7_months')}} </p></a>
                                    <a data-axis="{{$weeksAxis}}" data-data="{{$weeksData}}" data-color="#ffc107" class="btn last_7_weeks chart_links d-flex align-items-center" href="#0"><i class="fa fa-circle text-warning"></i> <p>{{__('dashboard.last_7_weeks')}}</p></a>
                                    {{--                                <a class="all_visits_chart d-flex align-items-center mr-5" href="#0"><i class="fa fa-circle text-secondary"></i> <p>{{__('dashboard.all_chart')}}</p></a>--}}
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="d-flex justify-content-start">
                                    <h5> {{__('dashboard.careers_in')}} </h5>
                                </div>
                                <div class="d-flex justify-content-start">
                                    <a data-axis="{{$careersYearsAxis}}" data-data="{{$careersYearsData}}" data-color="#27a444" class="btn last_7_years chart_links d-flex align-items-center" href="#0"><i class="fa fa-circle text-success"></i> <p>{{__('dashboard.last_7_years')}} </p></a>
                                    <a data-axis="{{$careersMonthsAxis}}" data-data="{{$careersMonthsData}}" data-color="#3abad6" class="btn last_7_months chart_links d-flex align-items-center" href="#0"><i class="fa fa-circle text-primary"></i> <p>{{__('dashboard.last_7_months')}} </p></a>
                                    <a data-axis="{{$careersWeeksAxis}}" data-data="{{$careersWeeksData}}" data-color="#ffc107" class="btn last_7_weeks chart_links d-flex align-items-center" href="#0"><i class="fa fa-circle text-warning"></i> <p>{{__('dashboard.last_7_weeks')}}</p></a>
                                    {{--                                <a class="all_careers_chart d-flex align-items-center mr-5" href="#0"><i class="fa fa-circle text-secondary"></i> <p>{{__('dashboard.all_chart')}}</p></a>--}}
                                </div>
                            </div>
                            <div class="col mt-4">
                                <div class="d-flex justify-content-start">
                                    <h5> {{__('dashboard.careers_applications_in')}} </h5>
                                </div>
                                <div class="d-flex justify-content-start">
                                    <a data-axis="{{$careerApplicationsYearsAxis}}" data-data="{{$careerApplicationsYearsData}}" data-color="#27a444" class="btn last_7_years chart_links d-flex align-items-center" href="#0"><i class="fa fa-circle text-success"></i> <p>{{__('dashboard.last_7_years')}} </p></a>
                                    <a data-axis="{{$careerApplicationsMonthsAxis}}" data-data="{{$careerApplicationsMonthsData}}" data-color="#3abad6" class="btn last_7_months chart_links d-flex align-items-center" href="#0"><i class="fa fa-circle text-primary"></i> <p>{{__('dashboard.last_7_months')}} </p></a>
                                    <a data-axis="{{$careerApplicationsWeeksAxis}}" data-data="{{$careerApplicationsWeeksData}}" data-color="#ffc107" class="btn last_7_weeks chart_links d-flex align-items-center" href="#0"><i class="fa fa-circle text-warning"></i> <p>{{__('dashboard.last_7_weeks')}}</p></a>
                                    {{--                                <a class="all_careers_chart d-flex align-items-center mr-5" href="#0"><i class="fa fa-circle text-secondary"></i> <p>{{__('dashboard.all_chart')}}</p></a>--}}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="line_chart"></div>
                </div>
            </div>
        </div>
    </div>

    <!-- ------------ general-report ------------- -->
{{--    <section class="general-report mt-5 shadow">--}}
{{--        <div class="row">--}}
{{--            <div class="col-lg-6">--}}
{{--                <div class="items">--}}
{{--                    <div class="top mb-3">--}}
{{--                        <span class="icon alert alert-info m-0">--}}
{{--                            <i class="bi bi-people-fill"></i>--}}
{{--                        </span>--}}
{{--                    </div>--}}
{{--                    <div class="bottom">--}}
{{--                        <div>--}}
{{--                            <p>{{__('dashboard.visit_in_year')}}</p>--}}
{{--                            <h2 class="counter mb-0 mt-1 fnt_rpt">{{$thisYearVisitors}}</h2>--}}
{{--                        </div>--}}
{{--                    </div>--}}
{{--                </div>--}}
{{--            </div>--}}
{{--            <div class="col-lg-6">--}}
{{--                <div class="items">--}}
{{--                    <div class="top mb-3">--}}
{{--                        <span class="icon alert alert-info m-0">--}}
{{--                            <i class="bi bi-people-fill"></i>--}}
{{--                        </span>--}}
{{--                    </div>--}}
{{--                    <div class="bottom">--}}
{{--                        <div>--}}
{{--                            <p>{{__('dashboard.visit_in_month')}}</p>--}}
{{--                            <h2 class="counter mb-0 mt-1 fnt_rpt">{{$thisMonthVisitors}}</h2>--}}
{{--                        </div>--}}
{{--                    </div>--}}
{{--                </div>--}}
{{--            </div>--}}
{{--            <div class="col-lg-6">--}}
{{--                <div class="items">--}}
{{--                    <div class="top mb-3">--}}
{{--                        <span class="icon alert alert-info m-0">--}}
{{--                            <i class="bi bi-people-fill"></i>--}}
{{--                        </span>--}}
{{--                    </div>--}}
{{--                    <div class="bottom">--}}
{{--                        <div>--}}
{{--                            <p>{{__('dashboard.visit_in_week')}}</p>--}}
{{--                            <h2 class="counter mb-0 mt-1 fnt_rpt">{{$thisWeekVisitors}}</h2>--}}
{{--                        </div>--}}
{{--                    </div>--}}
{{--                </div>--}}
{{--            </div>--}}
{{--            <div class="col-lg-6">--}}
{{--                <div class="items">--}}
{{--                    <div class="top mb-3">--}}
{{--                        <span class="icon alert alert-info m-0">--}}
{{--                            <i class="bi bi-people-fill"></i>--}}
{{--                        </span>--}}
{{--                    </div>--}}
{{--                    <div class="bottom">--}}
{{--                        <div>--}}
{{--                            <p>{{__('dashboard.visit_in_day')}}</p>--}}
{{--                            <h2 class="counter mb-0 mt-1 fnt_rpt">{{$thisDayVisitors}}</h2>--}}
{{--                        </div>--}}
{{--                    </div>--}}
{{--                </div>--}}
{{--            </div>--}}
{{--        </div>--}}
{{--    </section>--}}

{{--    <section class="general-report mt-5 shadow">--}}
{{--        <div class="row">--}}
{{--            <div class="col-lg-6">--}}
{{--                <div class="items">--}}
{{--                    <div class="top mb-3">--}}
{{--                        <span class="icon alert alert-warning m-0">--}}
{{--                            <i class="bi bi-cart-check-fill"></i>--}}
{{--                        </span>--}}
{{--                    </div>--}}
{{--                    <div class="bottom">--}}
{{--                        <div>--}}
{{--                            <p>{{__('careers.annual_careers')}}</p>--}}
{{--                            <h2 class="counter mb-0 mt-1 fnt_rpt">{{$thisYearReservations}}</h2>--}}
{{--                        </div>--}}
{{--                    </div>--}}
{{--                </div>--}}
{{--            </div>--}}
{{--            <div class="col-lg-6">--}}
{{--                <div class="items">--}}
{{--                    <div class="top mb-3">--}}
{{--                        <span class="icon alert alert-warning m-0">--}}
{{--                            <i class="bi bi-cart-check-fill"></i>--}}
{{--                        </span>--}}
{{--                    </div>--}}
{{--                    <div class="bottom">--}}
{{--                        <div>--}}
{{--                            <p>{{__('careers.monthly_careers')}}</p>--}}
{{--                            <h2 class="counter mb-0 mt-1 fnt_rpt">{{$thisMonthReservations}}</h2>--}}
{{--                        </div>--}}
{{--                    </div>--}}
{{--                </div>--}}
{{--            </div>--}}
{{--            <div class="col-lg-6">--}}
{{--                <div class="items">--}}
{{--                    <div class="top mb-3">--}}
{{--                        <span class="icon alert alert-warning m-0">--}}
{{--                            <i class="bi bi-cart-check-fill"></i>--}}
{{--                        </span>--}}
{{--                    </div>--}}
{{--                    <div class="bottom">--}}
{{--                        <div>--}}
{{--                            <p>{{__('careers.weekly_careers')}}</p>--}}
{{--                            <h2 class="counter mb-0 mt-1 fnt_rpt">{{$thisWeekReservations}}</h2>--}}
{{--                        </div>--}}
{{--                    </div>--}}
{{--                </div>--}}
{{--            </div>--}}
{{--            <div class="col-lg-6">--}}
{{--                <div class="items">--}}
{{--                    <div class="top mb-3">--}}
{{--                        <span class="icon alert alert-warning m-0">--}}
{{--                            <i class="bi bi-cart-check-fill"></i>--}}
{{--                        </span>--}}
{{--                    </div>--}}
{{--                    <div class="bottom">--}}
{{--                        <div>--}}
{{--                            <p>{{__('careers.daily_careers')}}</p>--}}
{{--                            <h2 class="counter mb-0 mt-1 fnt_rpt">{{$thisDayReservations}}</h2>--}}
{{--                        </div>--}}
{{--                    </div>--}}
{{--                </div>--}}
{{--            </div>--}}
{{--            <table class="table table-striped table-bordered">--}}
{{--                <thead>--}}
{{--                <tr>--}}
{{--                    <th>#</th>--}}
{{--                    <th>{{__('careers.name')}}</th>--}}
{{--                    <th>{{__('careers.service_careers_counts')}}</th>--}}
{{--                </tr>--}}
{{--                </thead>--}}
{{--                <tbody>--}}

{{--                @if(count($mostCommonServices))--}}
{{--                    @foreach($mostCommonServices as $mostCommonService)--}}
{{--                        <tr>--}}
{{--                            <td>{{$loop->iteration}}</td>--}}
{{--                            <td>{{$mostCommonService[0]['name']}}</td>--}}
{{--                            <td>{{count($mostCommonService)}}</td>--}}
{{--                        </tr>--}}
{{--                    @endforeach--}}
{{--                    @else--}}
{{--                    <tr>--}}
{{--                        <th colspan="3" class="text-center text-danger">{{__('careers.no_data_to_show')}}</th>--}}
{{--                    </tr>--}}
{{--                @endif--}}

{{--                </tbody>--}}
{{--            </table>--}}
{{--        </div>--}}
{{--    </section>--}}

    <!-- -------------- tables ----------------- -->
@endsection

@section('inner_js')

<!--------- new scripts ----------->

<script src="{{asset('assets/admin/js/lib/Chart.min.js')}}"></script>
<!-- ------- apex chart -------------- -->
<script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
<!-- ------- data table  -------------- -->
<script src="https://cdn.datatables.net/1.10.23/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.23/js/dataTables.bootstrap4.min.js"></script>
<!-- ----------- datepicker ----------- -->
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<!-- ---------- charts ---------- -->

    <script>

        let yearContainer = $('.last_7_years'),
            yearData = yearContainer.data('data'),
            yearName = yearContainer.children('p').html(),
            yearAxis = yearContainer.data('axis');


        let line_visits_chart_options = {
            series: [
                {name: yearName, data: yearData},
            ],
            colors: ['#27a444', '#3abad6', '#ffc107'],
            chart: {
                height: 350,
                type: 'area',
            },
            dataLabels: {
                enabled: false
            },
            stroke: {
                curve: 'smooth'
            },
            xaxis: {
                categories: yearAxis,
            },
            legend: {
                show: false,
                // position: 'top',
                // horizontalAlign: 'right',
                // offsetX: -10
            },
            tooltip: {
                x: {
                    format: 'dd/MM/yy HH:mm',
                },
            },
        };

        let chartSelector = document.querySelector("#line_chart");
        let chart = new ApexCharts(chartSelector, line_visits_chart_options);

        chart.render();


        $('.chart_links').click(function (e) {
            $('#line_chart').html('');
            e.preventDefault();

            $('a.chart_links').removeClass('disabled');
            $(this).addClass('disabled');
            let axis = $(this).data('axis'),
                data = $(this).data('data'),
                name = $(this).children('p').html(),
                color = $(this).data('color');

            chart.updateOptions({
                xaxis: {
                    categories: axis,
                },
                series: [{name: name, data: data}],
                colors: [color],
            });
        });


    </script>

@endsection
