@extends('admin.layouts.container')

@section('content')
<form>
<div class="side-title">
    <div class="row">
        <div class="col-lg-6">
            <h3>{{ $title }}</h3>
        </div>
        <div class="col-lg-6 valign">
            <div class="edit-buttons text-right w-100">
                <a href="{{ route ('galleries.destroyAll') }}" data-method="delete" class="butn statusButns status_1 tableAction btn disabled bg-warning"> <span>{{ __('dashboard.sendToTrash') }}</span></a>
                <a href="#" class="butn statusButns status_1 showArchive bg-primary"> <span> {{ __('dashboard.displayTrash') }} </span></a>

                <a href="{{ route ('galleries.destroyAll') }}" data-method="delete" class="butn statusButns status_0 tableAction btn disabled bg-danger force"> <span> {{ __('dashboard.delete') }} </span></a>
                <a href="{{ route ('galleries.restoreAll') }}" data-method="put" class="butn statusButns status_0 tableAction btn disabled bg-info"> <span> {{ __('dashboard.restore') }} </span></a>
                <a href="#" class="butn statusButns status_0 showActive bg-primary"> <span> {{ __('dashboard.displayActive') }} </span></a>
            </div>
        </div>
    </div>
</div>


    <table class="table table-hover table-bordered">
        <thead>
        <tr>
            <th scope="col">
                <div class="custom-control custom-checkbox">
                    <input type="checkbox" class="custom-control-input" id="selectall" name="example1">
                    <label class="custom-control-label" for="selectall"> </label>
                </div>
            </th>
            <th scope="col">{{ __('galleries.title') }}</th>
            <th scope="col">{{ __('galleries.type') }}</th>
            <th scope="col" colspan="2">{{ __('dashboard.created_at') }}</th>
            <th scope="col">{{ __('dashboard.processes') }}</th>
        </tr>
        </thead>

        <tbody class="response">
        <tr class="search_filter_form">
            <th scope="row"></th>
            <th scope="row">
                <input type="text" name="title" value="{{ $request->title ?? '' }}" class="form-control" placeholder="">
            </th>
            <td>
                <select name="type" class="form-control">
                    <option value="">{{__('galleries.type')}}</option>
                    <option value="image_type">{{__('galleries.image_type')}}</option>
                    <option value="video_type">{{__('galleries.video_type')}}</option>
                </select>
            </td>
            <td>
                <input type="date" placeholder="{{ __('dashboard.date_from') }}" name="date_from" value="{{ $request->date_from ?? '' }}" class=" form-control">
            </td>
            <td>
                <input type="date" placeholder="{{ __('dashboard.date_to') }}" name="date_to" value="{{ $request->date_to ?? '' }}" class=" form-control">
            </td>
            <th scope="col"><button type="button" class="butn color small search"><span><i class="fas fa-search"></i></span></button></th>
        </tr>
        </tbody>


    </table>
<!-- ------------ data table ------------- -->

<!-- ------------ sidemenu links ------------- -->
</form>
@endsection



<script>
/**
 * Importat to handle ajax requests for filters, deletes, trash and any proccess done on the table's data
 */
var dataTable={
    route: '{{ route("galleries.grid") }}'
};

</script>
@section('inner_js')
    <script>
        /**
         * Set local storage articleGallery key to null
         * it means add new photo success
         */
        $(document).ready(function () {
            localStorage.setItem('articleGallery', 'null');
            localStorage.setItem('oldArticleStorage', 'null')
        })
    </script>
@endsection
