@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{$head ?? '' }}</h3>
</div>
<div class="border-item">
    <form class="form-row add_type_form" method="post" action="{{ $action }}">
        @if($category ?? ''  && $category->id)
            @method('PUT')
        @endif
        @csrf

            <div class="form-group col-lg-12">
                <label>{{ meta('status', $lang) ?? __('categories.status') }}</label>
                <select name="status" class="form-control {{ $errors->has('status') ? 'is-invalid' : '' }}">
                    <option {{($category->status ?? null) == 1 ? 'selected' : ''}} value="1">{{__('categories.active')}}</option>
                    <option {{($category->status ?? null) == 0 ? 'selected' : ''}} value="0">{{__('categories.not_active')}}</option>
                </select>
            </div>
        @foreach($languages as $language)
        <div class="form-group col-lg-6">
            <label>{{ meta('name', $language->local) ?? __('categories.name') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <input type="text" class="form-control {{ $errors->has('name_'.$language->local) ? 'is-invalid' : '' }}" name="name_{{ $language->local }}" placeholder="{{ meta('name', $language->local) ?? __('categories.name') }}" value='{{ old("name_{$language->local}", $category[$language->local]->name ?? "") }}'/>
        </div>
        @endforeach

            {{--Start image container--}}
{{--            <div class="form-group col-lg-6">--}}
{{--                <label>{{ meta('image', $lang) ?? __('categories.image') }} </label>--}}
{{--                <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="{{old("image", $category->image ?? "")}}"/>--}}

{{--                <div class="photos image_main_photo {{ old('image', $category->image ?? '') ? ' wow fadeInUp' : 'hide' }}">--}}
{{--                    <div class="col-lg-12">--}}
{{--                        <div class="items">--}}
{{--                            <div class="img">--}}
{{--                                <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".image_pick_button">--}}
{{--                                    <img src="{{asset(old('image', $category->image ?? ''))}} "  id="image_holder" class="image_holder"/>--}}
{{--                                </a>--}}
{{--                            </div>--}}
{{--                            <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".image_main_photo" data-show=".image_pick_button"><i class="fas fa-times"></i></a>--}}
{{--                        </div>--}}
{{--                    </div>--}}
{{--                </div>--}}

{{--                <div class="clearfix"></div>--}}
{{--                <span class="input-group-btn image_pick_button {{ old('image', $category->image ?? '') ? 'hide' : '' }} ">--}}
{{--                <a id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" data-show=".image_main_photo" data-hide=".image_pick_button" class="lfm btn btn-primary text-light">--}}
{{--                    <i class="fas fa-camera-retro"></i> {{__('dashboard.choose')}}--}}
{{--                </a>--}}
{{--            </span>--}}
{{--            </div>--}}
            {{--End image container--}}

        <div class="text-center mt-5 col-12">
            <button class="butn add_type_button"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>

@endsection

@section('inner_js')

    <!-- Editor JS files -->
    <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>
    {{--    <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>--}}
    <script>
        var route_prefix = "{{ url(config('lfm.prefix')) }}";
        var url = "{{url('/')}}/",
            currentLanguage = "{{$lang}}",
            inputName = '';
    </script>
    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>

<script>
    sendAjax('.add_type_button', '.add_type_form');
</script>
@endsection
