(function( $ ){

  $.fn.filemanager = function(type, options) {
    type = type || 'file';
    this.on('click', function(e) {

        localStorage.setItem('photo_gallery', 'false');
        localStorage.setItem('article_gallery', 'false');
        localStorage.setItem('website_gallery_photos', 'false');
        localStorage.setItem('title', 'false');
        localStorage.setItem('url', 'false');

      var route_prefix = (options && options.prefix) ? options.prefix : '/laravel-filemanager';
      localStorage.setItem('target_input', $(this).data('input'));
      localStorage.setItem('target_href', $(this).data('href'));
      localStorage.setItem('target_preview', $(this).data('preview'));
      localStorage.setItem('target_container', $(this).data('container'));
      localStorage.setItem('target_append', $(this).data('append'));
      localStorage.setItem('target_append_with_title', $(this).data('append_with_title'));
      localStorage.setItem('target_replace', $(this).data('replace'));
      localStorage.setItem('target_show', $(this).data('show'));
      localStorage.setItem('target_hide', $(this).data('hide'));
      localStorage.setItem('target_showHide', $(this).hasClass('showHide'));

      localStorage.setItem('width', $(this).data('width'));
      localStorage.setItem('title', $(this).data('title'));
      localStorage.setItem('url', $(this).data('url'));

      $(this).data('cache') === 'photo_gallery' ? localStorage.setItem('photo_gallery', 'true') : '';
      $(this).data('cache') === 'article_gallery' ? localStorage.setItem('article_gallery', 'true') : '';
      $(this).data('cache') === 'website_gallery_photos' ? localStorage.setItem('website_gallery_photos', 'true') : '';



      window.open(route_prefix + '?type=' + type, 'FileManager', 'width=900,height=600');
      return false;
    });


  }

}) (jQuery);



function SetUrl(url, file_path){

    url= url.replace(/\/\//g,'/').replace(':/','://')
    file_path= file_path.replace(/\/\//g,'/')
    //set the value of the desired input to image url
    var target_input = $(localStorage.getItem('target_input'));
    if (target_input) {
        target_input.val(file_path);
    }

    var target_href = $(localStorage.getItem('target_href'));
    if (target_href) {
        target_href.prop('href', url);
    }

    /**
    * set or change the preview image src
    * There are several types of preview:
    * Add Image block, replace container with another image block or just replace the image
    */

    // var target_container = $(localStorage.getItem('target_container'));
    // if (target_container) {

    //     var target_append_with_title = $(localStorage.getItem('target_append_with_title'));

    //     var target_append = localStorage.getItem('target_append');

    //     let elemntDom= '<div class="col-lg-4"><div class="items"> ' +
    //     '<div class="img">' +
    //     '<a href="' + url + '" ><img src="' + url + '" alt=""></a></div>' +
    //     (target_append_with_title == true ? '<div class="info"><div class="img-title">' : '' ) +
    //     (target_append_with_title == true ? '<input type="text" name="titles[]" placeholder="add title">' : '') +
    //     (target_append == true ? '<input type="hidden" name= "images[]" placeholder="add title" value="' + file_path + '">'  : '')+
    //     (target_append_with_title == true ? '<span class="preview"> </span></div></div>' : '') +
    //     '<a href="#" class="close" ><i class="fas fa-times"></i></a>' +
    //     '</div></div>';

    //     var target_replace = localStorage.getItem('target_replace');
    //     if (target_replace) {
    //         target_container.html(elemntDom);
    //     } else {
    //         target_container.append(elemntDom);
    //     }
    // }

    //set or change the preview image src
    var target_preview = $(localStorage.getItem('target_preview'));
    if (target_preview) {
        if(url.endsWith('.pdf')){
            target_preview.attr('src', imgSrc);
        } else if(url.endsWith('.mp4')){
            target_preview.attr('src', videoPath);
        } else {
            target_preview.attr('src', url);
        }
    }

    var target_show = $(localStorage.getItem('target_show'));
    if (target_show) {
        target_show.show();
    }

    var target_hide = $(localStorage.getItem('target_hide'));
    if (target_hide) {
        target_hide.hide();
        target_show.children().show()

    }

    //set or change the preview image src
    var target_showHide = localStorage.getItem('target_showHide');
    if (target_showHide) {
        // $('.showHide').trigger('click');
    }

    var title = localStorage.getItem('title'),
        image_url = localStorage.getItem('url').replace(/\/\//g,'/'),
        input_name = inputName ? inputName : `image_title_${currentLanguage}[]`;
    if (title === 'true' && image_url === 'true'){
        localStorage.setItem('info', `
        <div class="info">
            <div class="img-title">
                 <input type="text" name="`+input_name+`" placeholder="`+imageTitle+`" value="">
                 <input type="text" name="image_url[]" placeholder="`+imageUrl+`">
                 <input type="hidden" name="images[]" value="`+target_input.val()+`">
                 <span class="preview"> </span>
            </div>
        </div>
        `);
    } else if(title === 'true'){
        localStorage.setItem('info', `
            <div class="info">
            <div class="img-title">
                 <input type="text" name="`+input_name+`" placeholder="`+imageTitle+`" value="">
               <input type="hidden" name="images[]" value="`+target_input.val()+`">
               <span class="preview"> </span>
            </div>
        </div>
        `);
    } else {
        localStorage.setItem('info', `<input type="hidden" name="images[]" value="`+target_input.val()+`">`);
    }

    // function that create block to append it
    let append , appendArray = [];

    function appendToPhotoRow(){
        var width = localStorage.getItem('width') !== '' ? localStorage.getItem('width') : 'col-md-4';
        (function (){
            append = '<div class="'+width+'"><div class="items">' +
                '<div class="img">' +
                '<a href="'+url+'" data-fancybox="gallery"><img src="'+url+'" alt=""></a></div>' +
                localStorage.getItem('info') +
                '<a href="#" class="close"><i class="fas fa-times"></i></a>' +
                '</div></div>';

            $(".photos .row").append(append);

        })();

        localStorage.setItem('oldPhotoStorage', 'null');
        localStorage.setItem('oldArticleStorage', 'null');
        localStorage.setItem('oldWebsiteGalleryPhoto', 'null');


        $(".photos .row").children('.row > div').each(function () {
            appendArray.push($(this).html());
        });

    }

    // Check local storage
    let photo_gallery = localStorage.getItem('photo_gallery'),
        article_gallery = localStorage.getItem('article_gallery'),
        website_gallery_photos = localStorage.getItem('website_gallery_photos');

    if (photo_gallery === 'true') {
        appendToPhotoRow();
        let oldPhotoStorage = JSON.parse(localStorage.getItem('oldPhotoStorage'));
        oldPhotoStorage !== null ?
            localStorage.setItem('photoGallery', JSON.stringify(oldPhotoStorage.concat(appendArray)))  :
            localStorage.setItem('photoGallery', JSON.stringify(appendArray));
        localStorage.setItem('articleGallery', 'null');
        localStorage.setItem('websiteGalleryPhoto', 'null');
    }

    if (article_gallery === 'true') {
        appendToPhotoRow();
        let oldArticleStorage = JSON.parse(localStorage.getItem('oldArticleStorage'));
        oldArticleStorage !== null ?
            localStorage.setItem('articleGallery', JSON.stringify(oldArticleStorage.concat(appendArray)))  :
            localStorage.setItem('articleGallery', JSON.stringify(appendArray));
        localStorage.setItem('photoGallery', 'null');
        localStorage.setItem('websiteGalleryPhoto', 'null');
    }

    if (website_gallery_photos === 'true') {
        appendToPhotoRow();
        let oldWebsiteGalleryPhoto = JSON.parse(localStorage.getItem('oldWebsiteGalleryPhoto'));
        oldWebsiteGalleryPhoto !== null ?
            localStorage.setItem('websiteGalleryPhoto', JSON.stringify(oldWebsiteGalleryPhoto.concat(appendArray)))  :
            localStorage.setItem('websiteGalleryPhoto', JSON.stringify(appendArray));
        localStorage.setItem('photoGallery', 'null');
        localStorage.setItem('articleGallery', 'null');

    }



}


// to disable remove the block
$('body').on('click', '.resetImage', function(e){
    e.preventDefault()
})

$('body').on('click', 'a.showHide', function(e){
    if ($(this).data('show')) {
        $($(this).data('show')).show()
    }
    if ($(this).data('hide')) {
        $($(this).data('hide')).hide();

    }
    if ($(this).data('empty')) {
        $($(this).data('empty')).val('')
    }
})
