<?php

use Illuminate\Database\Seeder;

class ServiceSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $images = [
            'assets/web/images/proj-1.png',
            'assets/web/images/proj-2.png',
            'assets/web/images/proj-3.png',
            'assets/web/images/content_1.jpg',
        ];

        foreach ($images as $image) {
            factory(\App\Service::class)->create(['image' => $image]);
        }


        foreach (languages() as $language) {
            foreach (\App\Service::cursor() as $service) {
                factory(\App\ServiceDescription::class)->create([
                    'service_id' => $service->id,
                    'language_id' => $language->id,
                ]);
            }
        }
    }
}
