<?php

use Illuminate\Database\Seeder;

class ReservationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        foreach (\App\Doctor::cursor() as $doctor) {
            $serviceId = array_random($doctor->service_ids, 1)[0];
            $service = \App\Service::withDescription([$serviceId])->first();
            $branchId = array_random($service->branch_ids, 1)[0];
            $appointment = \App\Appointment::where('doctor_id', $doctor->id)
                ->where('service_id', $serviceId)->first();
            $appointmentTimes = \App\AppointmentTime::where('appointment_id', $appointment->id)
                ->where('status', 'available')->inRandomOrder()->first();
            factory(\App\Reservation::class)->create([
                'durations' => $service->durations,
                'service_id' => $serviceId,
                'branch_id' => $branchId,
                'doctor_id' => $doctor->id,
                'appointment_date' => $appointment->appointment_date,
                'appointment_time' => $appointmentTimes->available_time,
                'status' =>  'un_confirmed',
            ]);

            $appointmentTimes->update(['status' => 'not_available']);
        }
    }
}
