<?php

use App\Partner;
use App\PartnerDescription;
use Illuminate\Database\Seeder;

class PartnerSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $images = [
            'assets/web/images/partner-6.svg',
            'assets/web/images/partner-5.svg',
            'assets/web/images/partner-4.svg',
            'assets/web/images/partner-3.svg',
            'assets/web/images/partner-2.svg',
            'assets/web/images/partner-1.svg',
        ];

        foreach ($images as $image) {
            factory(Partner::class)->create(['image' => $image]);
        }
        foreach (Partner::cursor() as $partner) {
            foreach (languages() as $language) {
                factory(PartnerDescription::class)->create([
                    'partner_id' => $partner->id,
                    'language_id' => $language->id,
                ]);
            }
        }
    }
}
