<?php

use Illuminate\Database\Seeder;

class PageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {


        factory(\App\Page::class)->create([
            'image' => 'assets/web/images/about-2.jpg',
            'meta' => [
                'video_url' => 'https://www.youtube.com/watch?v=z_kVb9QfEhI',
                'video' => null,

            ]
        ]); // About us
        factory(\App\Page::class)->create([
            'image' => 'assets/web/images/icons/about_cards_1.svg',
        ]); // Our Mission
        factory(\App\Page::class)->create([
            'image' => 'assets/web/images/icons/about_cards_2.svg',
        ]); // Our Vision
        factory(\App\Page::class)->create([
            'image' => 'assets/web/images/icons/about_cards_2.svg'
        ]); // Our Goals
        factory(\App\Page::class)->create([
            'image' => 'assets/web/images/icons/about_cards_4.svg'
        ]); // Our Values
        factory(\App\Page::class)->create(['image' => 'assets/web/images/content_1.jpg']); // Terms and Conditions
        factory(\App\Page::class)->create(['image' => 'assets/web/images/content_2.jpg']); // privacy policy
        factory(\App\Page::class)->create([
            'image' => 'assets/web/images/header-1.png',
            'meta' => [
                'banner_url' => 'https://alyomhost.com',
                'users' => [
                    'ar' => 'عملاؤنا',
                    'en' => 'Users',
                    'statistics' => 400
                ],
                'services' => [
                    'ar' => 'خدماتنا',
                    'en' => 'Services',
                    'statistics' => 890
                ],
                'employees' => [
                    'ar' => 'موظفينا',
                    'en' => 'Employees',
                    'statistics' => 400
                ],
                'projects' => [
                    'ar' => 'مشاريعنا',
                    'en' => 'Projects',
                    'statistics' => 890
                ],
            ]
        ]); // Banner
        factory(\App\Page::class)->create(); // Footer



        foreach (languages() as $language) {
            factory(\App\PageDescription::class)->create([
                'page_title' => 'About us',
                'title' => 'World Full of Potentials',
                'description' => 'But I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally encounter consequences that are extremely painful. Nor again is there anyone who loves or pursues or desires to obtain pain of itself, because it is pain, but because occasionally circumstances occur in which toil and pain can procure him some great pleasure. To take a trivial example, which of us ever undertakes laborious physical exercise, except to obtain some advantage from it? But who has any right to find fault with a man who chooses to enjoy a pleasure that has no annoying consequences, or one who avoids a pain that produces no resultant pleasure? On the other hand, we denounce with righteous indignation and dislike men who are so beguiled and demoralized by the charms of pleasure of the moment, so blinded by desire, that they cannot foresee the pain and trouble that are bound to ensue; and equal blame belongs to those who fail in their duty through weakness of will, which is the same as saying through shrinking from toil and pain.',
                'page_id' => 1,
                'language_id' => $language->id,
            ]);
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Our Mission',
                'title' => 'Our Mission',
                'description' => 'But I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings.',
                'page_id' => 2,
                'language_id' => $language->id,
            ]);

            factory(\App\PageDescription::class)->create([
                'page_title' => 'Our Vision',
                'title' => 'Our Vision',
                'description' => 'But I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings. But I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings.',
                'page_id' => 3,
                'language_id' => $language->id,
            ]);
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Our Goals',
                'title' => 'Our Goals',
                'description' => 'But I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings.',
                'page_id' => 4,
                'language_id' => $language->id,
            ]);
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Our Values',
                'title' => 'Our Values',
                'description' => 'But I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings.',
                'page_id' => 5,
                'language_id' => $language->id,
            ]);


            factory(\App\PageDescription::class)->create([
                'page_title' => 'Terms & Conditions',
                'title' => 'Terms & Conditions',
                'description' => 'But I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally encounter consequences that are extremely painful. Nor again is there anyone who loves or pursues or desires to obtain pain of itself, because it is pain, but because occasionally circumstances occur in which toil and pain can procure him some great pleasure. To take a trivial example, which of us ever undertakes laborious physical exercise, except to obtain some advantage from it? But who has any right to find fault with a man who chooses to enjoy a pleasure that has no annoying consequences, or one who avoids a pain that produces no resultant pleasure? On the other hand, we denounce with righteous indignation and dislike men who are so beguiled and demoralized by the charms of pleasure of the moment, so blinded by desire, that they cannot foresee the pain and trouble that are bound to ensue; and equal blame belongs to those who fail in their duty through weakness of will, which is the same as saying through shrinking from toil and pain.',
                'page_id' => 6,
                'language_id' => $language->id,
            ]);

            factory(\App\PageDescription::class)->create([
                'page_title' => 'Privacy Policy',
                'title' => 'Privacy Policy',
                'description' => 'But I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally encounter consequences that are extremely painful. Nor again is there anyone who loves or pursues or desires to obtain pain of itself, because it is pain, but because occasionally circumstances occur in which toil and pain can procure him some great pleasure. To take a trivial example, which of us ever undertakes laborious physical exercise, except to obtain some advantage from it? But who has any right to find fault with a man who chooses to enjoy a pleasure that has no annoying consequences, or one who avoids a pain that produces no resultant pleasure? On the other hand, we denounce with righteous indignation and dislike men who are so beguiled and demoralized by the charms of pleasure of the moment, so blinded by desire, that they cannot foresee the pain and trouble that are bound to ensue; and equal blame belongs to those who fail in their duty through weakness of will, which is the same as saying through shrinking from toil and pain.',
                'page_id' => 7,
                'language_id' => $language->id,
            ]);
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Banner',
                'title' => 'Welcome on board',
                'description' => 'But I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete',
                'page_id' => 8,
                'language_id' => $language->id,
            ]);

            factory(\App\PageDescription::class)->create([
                'page_title' => 'الفوتر',
                'title' => null,
                'description' => 'يعتبر مركز بصمة القدم أحد المركز الرائدة في مجال التأهيل بالمملكة العربية السعودية حيث يساهم المركز في رفع مستوى وجودة خدمات التأهيل بالمملكة من خلال استقطاب أفضل الكوادر المتخصصة واستخدام احث تقنيات التشخيص والعلاج.',
                'page_id' => 9,
                'language_id' => $language->id,
            ]);

        }
    }
}
