<?php

use Illuminate\Database\Seeder;

class GallerySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $images = [
            'assets/web/images/content_1.jpg',
            'assets/web/images/content_3.jpg',
            'assets/web/images/content_5.jpg',
            'assets/web/images/content_2.jpg',
            'assets/web/images/content_4.jpg',
            'assets/web/images/proj-1.png',
            'assets/web/images/proj-1.png',
            'assets/web/images/content_5.jpg',
        ];

        foreach ($images as $image) {
            factory(\App\Gallery::class)->create(['type' => 'image_type', 'image' => $image]);
            factory(\App\Gallery::class)->create(['type' => 'video_type', 'image' => $image, 'video_url' => 'https://www.youtube.com/watch?v=h0pEL8GklCc']);
        }


        foreach (languages() as $language) {
            foreach (\App\Gallery::cursor() as $gallery) {
                factory(\App\GalleryDescription::class)->create([
                    'title' => $gallery->type == 'video_type' ? 'Media title' : null,
                    'gallery_id' => $gallery->id,
                    'language_id' => $language->id,
                ]);
            }
        }

    }
}
