<?php

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class GalleriesCategoriesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

         factory(\App\Category::class, 3)->create(['type' => 'image']);
         factory(\App\Category::class, 3)->create(['type' => 'video']);

        foreach (\App\Category::cursor() as $category) {
            foreach (languages() as $language) {
                factory(\App\CategoryDescription::class)->create([
                    'category_id' => $category->id,
                    'language_id' => $language->id
                ]);
            }
        }

    }
}
