<?php

use Illuminate\Database\Seeder;

class BranchSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $branches = factory(\App\Branch::class, 9)->create();

        foreach ($branches as $branch) {
            foreach (languages() as $language) {
                factory(\App\BranchDescription::class)->create([
                    'branch_id' => $branch->id,
                    'language_id' => $language->id,
                ]);
            }

        }

    }
}
