<?php

use App\Article;
use App\ArticleDescription;
use Illuminate\Database\Seeder;

class ArticleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $images = [
            'assets/web/images/proj-1.png',
            'assets/web/images/proj-2.png',
            'assets/web/images/proj-3.png',
        ];

        foreach ($images as $image) {
            factory(Article::class, 3)->create(['image' => $image]);
        }

        foreach (languages() as $language){
            foreach (Article::cursor() as $article) {
                factory(ArticleDescription::class)->create([
                    'article_id' => $article->id,
                    'language_id' => $language->id,
                ]);
            }

        }
    }
}
