<?php

use Illuminate\Database\Seeder;

class AppointmentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        foreach (\App\Doctor::cursor() as $doctor) {
            factory(\App\Appointment::class)->create([
                'doctor_id' => $doctor->id,
                'service_id' => array_random($doctor->service_ids, 1)[0],
            ]);
        }

        foreach (\App\Appointment::cursor() as $appointment) {
            $doctorStartShift = \Illuminate\Support\Carbon::make($appointment->doctor_start_shift);
            $doctorEndShift = \Illuminate\Support\Carbon::make($appointment->doctor_end_shift);
            $serviceDuration = $appointment->service->durations;
            $diff = $doctorEndShift->diff($doctorStartShift)->h;
            if ($diff){
                while (($doctorEndShift->diff($doctorStartShift)->h || ($doctorEndShift->diff($doctorStartShift)->i == $serviceDuration))){
                    factory(\App\AppointmentTime::class)->create([
//                        'available_time' => $doctorStartShift->format('h:i'),
                        'available_time' => $doctorStartShift->toTimeString(),
                        'appointment_id' => $appointment->id
                    ]);
                    $doctorStartShift = $doctorStartShift->addMinutes($serviceDuration);
                    if ($doctorEndShift->diff($doctorStartShift)->h == 0 && $doctorEndShift->diff($doctorStartShift)->i >= $serviceDuration){
                        factory(\App\AppointmentTime::class)->create([
//                            'available_time' => $doctorStartShift->format('h:i'),
                            'available_time' => $doctorStartShift->toTimeString(),
                            'appointment_id' => $appointment->id
                        ]);
                        $doctorStartShift = $doctorStartShift->addMinutes($serviceDuration);
                    }
                }
            }
        }
    }
}
