<?php

use Illuminate\Database\Seeder;

class AppSliderSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $image = 'assets/web/images/header-1.png';

        factory(\App\AppSlider::class, 3)->create(['type' => 'image_only', 'image' => $image, 'service_id' => null]); // image type
        factory(\App\AppSlider::class, 3)->create(['type' => 'image_service', 'image' => $image]); // service type
        factory(\App\AppSlider::class, 3)->create(['type' => 'image_external_url', 'image' => $image, 'url' => 'https://alyomhost.com', 'service_id' => null]); // external_url type


        foreach (languages() as $language) {
            foreach (\App\AppSlider::cursor() as $slider) {
                factory(\App\AppSliderDescription::class)->create([
                    'app_slider_id' => $slider->id,
                    'language_id' => $language->id,
                ]);
            }
        }

    }

}
