<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTagDescriptionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tag_descriptions', function (Blueprint $table) {
            $table->id();
            $table->string('name',100);

            $table->unsignedBigInteger('tag_id')->index();
            $table->unsignedBigInteger('language_id')->index();

            $table->foreign('tag_id')->references('id')->on('tags')->cascadeOnDelete();

            $table->engine = 'InnoDB';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tag_descriptions');
    }
}
