<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateReviewDescriptionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('review_descriptions', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('review');

            $table->unsignedBigInteger('review_id')->index();
            $table->unsignedBigInteger('language_id')->index();

            $table->foreign('review_id')->references('id')->on('reviews')->cascadeOnDelete();

            $table->engine = 'InnoDB';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('review_descriptions');
    }
}
