<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserNotificationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users_notifications', function (Blueprint $table) {
            $table->id();
            $table->longText('title');
            $table->longText('message');
//            $table->unsignedBigInteger('user_id')->nullable()->index();
//            $table->unsignedBigInteger('service_id')->nullable()->index();
//            $table->enum('notification_type', ['tel_consultation', 'zoom_consultation', 'office_consultation', 'inside_doc_request', 'outside_doc_request', 'issues', 'training'])->nullable();
//            $table->enum('send_to', ['all_user'])->nullable();
            $table->json('is_read')->nullable();
            $table->json('is_seen')->nullable();
            $table->boolean('admin_read')->nullable();

            $table->timestamps();
            $table->softDeletes();
            $table->engine = 'InnoDB';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users_notifications');
    }
}
