<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCategoryDescriptionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('category_descriptions', function (Blueprint $table) {

            $table->id();
            $table->string('name',100);
//            $table->string('slug',100);
//            $table->string('keywords',400);
//            $table->text('meta_description');

            $table->unsignedBigInteger('category_id')->index();
            $table->unsignedBigInteger('language_id')->index();

            $table->foreign('category_id')->references('id')->on('categories')->cascadeOnDelete();

            $table->engine = 'InnoDB';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('category_descriptions');
    }
}
