<?php

/** @var \Illuminate\Database\Eloquent\Factory $factory */

use App\User;
use App\Article;
use App\CategoryDescription;
use Faker\Generator as Faker;

$factory->define(Article::class, function (Faker $faker) {
    $tagsIds = \App\Tag::pluck('id')->toArray();
    shuffle($tagsIds);

    return [
        'category_id' => $faker->randomElement(\App\Category::pluck('id')->toArray()),
        'tags_ids' => array_slice($tagsIds, 0, 3),
    ];
});
