<?php

/** @var \Illuminate\Database\Eloquent\Factory $factory */

use App\Appointment;
use Faker\Generator as Faker;

$factory->define(Appointment::class, function (Faker $faker) {
    $start = \Illuminate\Support\Carbon::make('9:00');
    $end = \Illuminate\Support\Carbon::make('17:00');
    $date = \Illuminate\Support\Carbon::now()->addDays($faker->randomNumber(1));
    return [
        'doctor_start_shift' => $start,
        'doctor_end_shift' => $end,
        'appointment_date' => $date->format('Y-m-d'),
        'appointment_date_to_text' => $date->format('F Y d'),
    ];
});
