<?php

namespace App;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class SpecialNeed
 * @package App
 * @mixin Builder
 */

class WorkHour extends Model
{
    use SoftDeletes;

    protected $fillable = ['contact_us_work_time'];

    protected $casts = ['contact_us_work_time' => 'array'];

    public static function withDescription()
    {
        $query = self::join('work_hour_descriptions as wHDesc', 'wHDesc.work_hour_id', 'work_hours.id')
            ->where('wHDesc.language_id', currentLanguage()->id)
            ->select(['work_hours.id', 'work_hours.contact_us_work_time', 'wHDesc.home_page_work_time',]);

        return $query->first();
    }

}
