<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * @property mixed replies
 */
class VisitorMessage extends Model
{
    //use soft delete
    use SoftDeletes;

    protected $fillable = ['name', 'subject', 'email', 'phone', 'read', 'reply', 'message'];


    /**
     * Return all replies for message
     * @return HasMany
     */
    public function replies() :HasMany
    {
        return $this->hasMany(VisitorMessageReply::class);
    }

}
